/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import java.util.List;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.component.ComponentDesignConverter;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.ModeEnum;

public class ListDesignConverter
implements ComponentDesignConverter {
    public JRPrintElement convert(ReportConverter reportConverter, JRComponentElement element) {
        ListComponent list = (ListComponent)element.getComponent();
        if (list == null || list.getContents() == null) {
            return null;
        }
        JRBasePrintFrame frame = new JRBasePrintFrame(reportConverter.getDefaultStyleProvider());
        reportConverter.copyBaseAttributes(element, frame);
        ListContents contents = list.getContents();
        if (contents.getHeight() > 0) {
            JRBasePrintFrame contentsFrame = new JRBasePrintFrame(reportConverter.getDefaultStyleProvider());
            contentsFrame.setX(0);
            contentsFrame.setY(0);
            contentsFrame.setWidth(element.getWidth());
            contentsFrame.setHeight(contents.getHeight());
            contentsFrame.setMode(ModeEnum.TRANSPARENT);
            List children = contents.getChildren();
            if (children != null) {
                ConvertVisitor contentsVisitor = new ConvertVisitor(reportConverter, contentsFrame);
                for (JRChild child : children) {
                    child.visit(contentsVisitor);
                }
            }
            frame.addElement(contentsFrame);
        }
        return frame;
    }
}

