/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.websocket.tomcat;

import com.vmware.vise.vim.messaging.context.support.ClientIdHolder;
import com.vmware.vise.vim.messaging.marshall.Marshaller;
import com.vmware.vise.vim.messaging.websocket.Controller;
import com.vmware.vise.vim.messaging.websocket.MessageSendingOperations;
import com.vmware.vise.vim.messaging.websocket.WebsocketCallbacks;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.WsOutbound;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class MessageSendingOperationsImpl
implements MessageSendingOperations {
    private static final Log _logger = LogFactory.getLog(MessageSendingOperationsImpl.class);
    private final List<DefaultMessageInbound> messageInbounds = new LinkedList<DefaultMessageInbound>();
    private final Marshaller marshaller;
    private final WebsocketCallbacks wsCallbacks;

    public void destroy() throws IOException {
        for (DefaultMessageInbound defaultMessageInbound : this.messageInbounds) {
            defaultMessageInbound.getWsOutbound().close(0, null);
        }
    }

    public MessageSendingOperationsImpl(Marshaller marshaller) {
        this.marshaller = marshaller;
        this.wsCallbacks = new WebsocketCallbacks();
    }

    public void add(DefaultMessageInbound defaultMessageInbound) {
        this.messageInbounds.add(defaultMessageInbound);
    }

    public void remove(DefaultMessageInbound defaultMessageInbound) {
        Runnable runnable;
        this.messageInbounds.remove((Object)defaultMessageInbound);
        if (this.messageInbounds.isEmpty() && (runnable = this.wsCallbacks.getOnClose()) != null) {
            runnable.run();
        }
    }

    @Override
    public void send(CharBuffer charBuffer) {
        for (DefaultMessageInbound defaultMessageInbound : this.messageInbounds.toArray(new DefaultMessageInbound[this.messageInbounds.size()])) {
            charBuffer.position(0);
            WsOutbound wsOutbound = defaultMessageInbound.getWsOutbound();
            try {
                wsOutbound.writeTextMessage(charBuffer);
            }
            catch (IOException iOException) {
                _logger.warn((Object)"Websocket is closed message Inbound is no longer valid.");
            }
        }
    }

    @Override
    public void sendMessage(Object object) throws IOException {
        this.send(this.marshaller.marshall(object));
    }

    @Override
    public void setOnClose(Runnable runnable) {
        this.wsCallbacks.setOnClose(runnable);
    }

    public static final class DefaultMessageInbound
    extends MessageInbound {
        private final List<Controller> liveUpdatesControllers;
        private String clientId;
        private final Marshaller marshaller;
        private MessageSendingOperationsImpl messageTemplate;

        public DefaultMessageInbound(List<Controller> list, Marshaller marshaller, MessageSendingOperationsImpl messageSendingOperationsImpl) {
            this.liveUpdatesControllers = list;
            this.marshaller = marshaller;
            this.messageTemplate = messageSendingOperationsImpl;
        }

        protected void onBinaryMessage(ByteBuffer byteBuffer) throws IOException {
        }

        protected void onClose(int n) {
            this.messageTemplate.remove(this);
            super.onClose(n);
        }

        protected void onTextMessage(CharBuffer charBuffer) throws IOException {
            ClientIdHolder.setClientId(this.clientId);
            if (this.liveUpdatesControllers != null) {
                for (Controller controller : this.liveUpdatesControllers) {
                    try {
                        Object object = controller.handleRequest(charBuffer);
                        if (object == null) continue;
                        this.getWsOutbound().writeTextMessage(this.marshaller.marshall(object));
                    }
                    catch (Exception exception) {
                        _logger.error((Object)("Live-updates controller [" + controller + "] failed to handle the request"), (Throwable)exception);
                    }
                }
            }
            ClientIdHolder.resetClientId();
        }

        void setClientId(String string) {
            this.clientId = string;
        }
    }
}

