/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.core.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.vmware.cis.core.util.CollectionsUtil;
import com.vmware.cis.core.util.ImmutableUtils;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractStoreBackedMap<K, V> {
    private final Log _log;
    private AtomicLong _updateSeqNo = new AtomicLong(0L);
    protected final ConcurrentMap<K, UpdatedValue<V>> _updates;
    protected final ConcurrentMap<K, V> _storeBackedMap;
    private volatile boolean _isLoading;
    private volatile boolean _shutdown;
    private final ConcurrentMap<Long, BlockingFuture<Void>> _notifications = new ConcurrentHashMap<Long, BlockingFuture<Void>>();
    private final Object _finalizer = new Object(){

        protected void finalize() throws Throwable {
            AbstractStoreBackedMap.this.shutDown();
        }
    };
    private final UpdateFromStoreFunction<K, V> _storeFunc;
    private final MapFunctions<K, UpdatedValue<V>, V> _mapFunctions;
    private final Map<K, V> _map;
    protected ImmutableUtils.TransformMapValueFunc<UpdatedValue<V>, V> TRANSFORM_FUNC = new ImmutableUtils.TransformMapValueFunc<UpdatedValue<V>, V>(){

        @Override
        public V to(Object key, UpdatedValue<V> from) {
            return from._value;
        }

        @Override
        public UpdatedValue<V> from(Object key, V to) {
            return new UpdatedValue(0L, to);
        }
    };

    protected AbstractStoreBackedMap(ConcurrentMap<K, V> storeBackedMap, ConcurrentMap<K, UpdatedValue<V>> updates, String name, UpdateFromStoreFunction<K, V> storeFunc, MapFunctions<K, UpdatedValue<V>, V> mapFunctions) {
        this._log = LogFactory.getLog((String)(AbstractStoreBackedMap.class.getName() + "-" + name));
        this._storeBackedMap = storeBackedMap;
        this._updates = updates;
        this._mapFunctions = mapFunctions;
        this._storeFunc = storeFunc;
        Map<K, V> concatMap = this.getConcatedMap();
        this._map = ImmutableUtils.filteredMap(concatMap, new Predicate<Map.Entry<K, V>>(){

            public boolean apply(Map.Entry<K, V> e) {
                return e != null && e.getKey() != null && e.getValue() != null;
            }
        });
    }

    public long getSyncSeq() {
        return this._updateSeqNo.get();
    }

    public void put(K key, V value) {
        this.preConditionCheck(key, value);
        this.internalUpdate(key, value);
    }

    private void internalUpdate(K key, V value) {
        long seq = this._updateSeqNo.get();
        if (this._isLoading) {
            ++seq;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Adding  key=" + key + " with update seq " + seq + " and value = " + value));
        }
        this._updates.put(key, new UpdatedValue<V>(seq, value));
    }

    public void remove(K key) {
        this.preConditionCheck(key);
        this.internalUpdate(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updatesFromStore(Update<K, V> update, UpdateNotification<K, V> updateNotification) {
        updateNotification.start();
        this._isLoading = true;
        LinkedHashMap updateCallbacks = new LinkedHashMap();
        long seq = this._updateSeqNo.get();
        try {
            Object oldValue;
            if (update.isDelta()) {
                for (Map.Entry<K, V> e : update.getMap().entrySet()) {
                    if (e.getKey() == null) continue;
                    oldValue = e.getValue() == null ? this._storeBackedMap.remove(e.getKey()) : this._storeBackedMap.put(e.getKey(), e.getValue());
                    this.addChangeNotification(updateNotification, seq, e.getKey(), e.getValue(), oldValue, updateCallbacks);
                }
            } else {
                for (Map.Entry<K, V> e : update.getMap().entrySet()) {
                    if (e.getKey() == null) continue;
                    oldValue = e.getValue() == null ? this._storeBackedMap.remove(e.getKey()) : this._storeBackedMap.put(e.getKey(), e.getValue());
                    this.addChangeNotification(updateNotification, seq, e.getKey(), e.getValue(), oldValue, updateCallbacks);
                }
                Sets.SetView difference = Sets.difference(this._storeBackedMap.keySet(), update.getMap().keySet());
                for (Object key : difference) {
                    Object oldValue2 = this._storeBackedMap.remove(key);
                    this.addChangeNotification(updateNotification, seq, key, null, oldValue2, updateCallbacks);
                }
            }
            this.removeUpdates(seq, updateCallbacks, updateNotification);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Marking all future task with seq  <= " + seq + " to complete."));
            }
            Iterator iter = this._notifications.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<K, V> e;
                e = iter.next();
                if ((Long)e.getKey() >= seq) continue;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Marking future task waiting for sync seq  " + e.getKey() + " to complete."));
                }
                ((BlockingFuture)e.getValue()).set();
                iter.remove();
            }
        }
        finally {
            this._updateSeqNo.incrementAndGet();
            this._isLoading = false;
            for (Runnable callback : updateCallbacks.values()) {
                callback.run();
            }
            updateNotification.done(seq);
        }
    }

    private void addChangeNotification(UpdateNotification<K, V> updateNotification, long seq, K key, V newValue, V oldValue, Map<K, Runnable> updateCallbacks) {
        UpdatedValue updatedValue = (UpdatedValue)this._updates.get(key);
        if (updatedValue != null) {
            if (updatedValue._seq >= seq) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Value updated by this client has sync seq " + updatedValue._seq + " and values from back is being synced for seq " + seq + ". Value updated by client is " + updatedValue._value + " and value received from the backend is " + newValue));
                }
                return;
            }
            oldValue = updatedValue._value;
        }
        if (!this.isSame(newValue, oldValue)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Value got from backend is not the same as the one updated by this client. For key " + key + " value updates by this client is " + oldValue + ". Value received from back end is " + newValue));
            }
            this.addupdateCallback(updateNotification, key, updateCallbacks, newValue, oldValue);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Key " + key + " updated by this client " + oldValue + " is same as received from the backend " + newValue));
        }
    }

    private void addupdateCallback(final UpdateNotification<K, V> updateNotification, final K key, Map<K, Runnable> updateCallbacks, final V finalNewValue, final V finalOldValue) {
        updateCallbacks.put(key, new Runnable(){

            @Override
            public void run() {
                try {
                    updateNotification.change(new Change<Object, Object>(key, finalNewValue, finalOldValue));
                }
                catch (Throwable t) {
                    AbstractStoreBackedMap.this._log.warn((Object)("Error occured sending notification for key " + key + " newValue=" + finalNewValue + " oldValue=" + finalOldValue), t);
                }
            }
        });
    }

    private boolean isSame(V newValue, V oldValue) {
        if (newValue == null ^ oldValue == null) {
            return false;
        }
        if (newValue == null) {
            return true;
        }
        return this._storeFunc.isSame(oldValue, newValue);
    }

    private void removeUpdates(long seq, Map<K, Runnable> updateCallbacks, UpdateNotification<K, V> updateNotification) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Removing updates with seq <= " + seq));
        }
        for (Map.Entry e : this._updates.entrySet()) {
            if (((UpdatedValue)e.getValue())._seq >= seq || !this._updates.remove(e.getKey(), e.getValue())) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Found an update with seq " + ((UpdatedValue)e.getValue())._seq + ", key=" + e.getKey() + " and value=" + ((UpdatedValue)e.getValue())._value));
                this._log.debug((Object)("Value got from backend store " + this._storeBackedMap.get(e.getKey())));
            }
            if (updateCallbacks.containsKey(e.getKey())) continue;
            Object oldValue = ((UpdatedValue)e.getValue())._value;
            Object newValue = this._storeBackedMap.get(e.getKey());
            if (this.isSame(newValue, oldValue)) continue;
            this.addupdateCallback(updateNotification, e.getKey(), updateCallbacks, newValue, oldValue);
        }
    }

    public Future<Void> syncNotification() {
        BlockingFuture<Void> future;
        long seq = this._updateSeqNo.get();
        if (this._isLoading) {
            ++seq;
        }
        if ((future = (BlockingFuture<Void>)this._notifications.get(seq)) == null) {
            future = new BlockingFuture();
            BlockingFuture<Void> existing = this._notifications.putIfAbsent(seq, future);
            if (existing != null) {
                future = existing;
            }
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Register a sucn notification for seq " + seq));
        }
        return future;
    }

    public Map<K, V> getMap() {
        return this._map;
    }

    protected Map<K, V> getConcatedMap() {
        Map<K, V> transformedMap = this._mapFunctions.transform(this._updates, this.TRANSFORM_FUNC);
        Map<K, V> concatMap = this._mapFunctions.concat(transformedMap, this._storeBackedMap);
        return concatMap;
    }

    private void preConditionCheck(Object ... arr) {
        this.isStateValid();
        CollectionsUtil.checkForContentsNotNull(Arrays.asList(arr));
    }

    public void shutDown() {
        this._shutdown = true;
        this._storeBackedMap.clear();
        this._updates.clear();
    }

    private void isStateValid() {
        if (this._shutdown) {
            throw new IllegalStateException("Shutdown");
        }
    }

    protected static interface MapFunctions<K, FV, V> {
        public Map<K, V> transform(Map<K, FV> var1, ImmutableUtils.TransformMapValueFunc<FV, V> var2);

        public Map<K, V> concat(Map<K, V> var1, Map<K, V> var2);
    }

    public static class Change<K, V> {
        private final K _key;
        private final V _serverValue;
        private final V _clientValue;

        public Change(K key, V serverValue, V clientValue) {
            this._key = key;
            this._serverValue = serverValue;
            this._clientValue = clientValue;
        }

        public K getKey() {
            return this._key;
        }

        public V getServerValue() {
            return this._serverValue;
        }

        public V getClientValue() {
            return this._clientValue;
        }
    }

    public static interface UpdateNotification<K, V> {
        public void start();

        public void change(Change<K, V> var1);

        public void done(long var1);
    }

    public static interface ChangeListener<K, V> {
        public UpdateNotification<K, V> newUpdateNotification();
    }

    public static interface UpdateFromStoreFunction<K, V> {
        public boolean isSame(V var1, V var2);
    }

    public static class Update<K, V> {
        private final boolean _isDelta;
        private final Map<K, V> _map;

        public Update(boolean isDelta, Map<K, V> map) {
            this._isDelta = isDelta;
            this._map = map;
        }

        public boolean isDelta() {
            return this._isDelta;
        }

        public Map<K, V> getMap() {
            return this._map;
        }
    }

    protected static class UpdatedValue<E> {
        private final long _seq;
        private final E _value;

        public UpdatedValue(long seq, E value) {
            this._seq = seq;
            this._value = value;
        }

        public long getSeq() {
            return this._seq;
        }

        public E getVal() {
            return this._value;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(this._seq).append(" ").append(this._value);
            return str.toString();
        }
    }
}

