/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.core.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ImmutableMaskedMap<K, V>
implements Map<K, V> {
    private final Map<K, V> _map;
    private final Collection<V> _values;
    private final Set<Map.Entry<K, V>> _entrySet;
    private final Set<K> _keySet;
    private final Filter<K> _filter;

    public ImmutableMaskedMap(Filter<K> filter, Map<K, V> map) {
        this._filter = filter;
        this._map = map;
        this._entrySet = new EntrySet();
        this._values = new CollectionImpl<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private Iterator<Map.Entry<K, V>> i;
                    {
                        this.i = ImmutableMaskedMap.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.i.next().getValue();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this._keySet = new SetImpl<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private Iterator<Map.Entry<K, V>> i;
                    {
                        this.i = ImmutableMaskedMap.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public K next() {
                        return this.i.next().getKey();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public int size() {
        return this._filter.calculateSize(this._map);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this._filter.isSelected(key)) {
            return false;
        }
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, V> e : this._map.entrySet()) {
            if (!this._filter.isSelected(e.getKey())) continue;
            if (e.getValue() == value) {
                return true;
            }
            if (e.getValue() == null || !e.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (!this._filter.isSelected(key)) {
            return null;
        }
        return this._map.get(key);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return this._keySet;
    }

    @Override
    public Collection<V> values() {
        return this._values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet;
    }

    private abstract class SetImpl<E>
    extends CollectionImpl<E>
    implements Set<E> {
        private SetImpl() {
        }
    }

    private abstract class CollectionImpl<E>
    extends AbstractCollection<E> {
        private CollectionImpl() {
        }

        @Override
        public int size() {
            return ImmutableMaskedMap.this.size();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapEntryImpl
    implements Map.Entry<K, V> {
        private Map.Entry<K, V> e;

        MapEntryImpl(Map.Entry<K, V> e) {
            this.e = e;
        }

        @Override
        public K getKey() {
            return this.e.getKey();
        }

        @Override
        public V getValue() {
            return this.e.getValue();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntrySet
    extends SetImpl<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<K, V>> _entrySetIter;
                private Map.Entry<K, V> _next;
                {
                    this._entrySetIter = ImmutableMaskedMap.this._map.entrySet().iterator();
                    this.moveToNextValidElement();
                }

                @Override
                public boolean hasNext() {
                    return this._next != null;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this._next == null) {
                        throw new NoSuchElementException();
                    }
                    MapEntryImpl result = new MapEntryImpl(this._next);
                    this._next = null;
                    this.moveToNextValidElement();
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private void moveToNextValidElement() {
                    while (this._entrySetIter.hasNext()) {
                        Map.Entry next = this._entrySetIter.next();
                        if (!ImmutableMaskedMap.this._filter.isSelected(next.getKey())) continue;
                        this._next = next;
                        break;
                    }
                }
            };
        }
    }

    public static interface Filter<K> {
        public boolean isSelected(Object var1);

        public int calculateSize(Map<K, ?> var1);
    }
}

