/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.core.util;

public class SetOnceReference<T> {
    private volatile T _volatileRef;
    private T _unSafeRef;
    private final T _initValue;

    public SetOnceReference() {
        this(null);
    }

    public SetOnceReference(T initValue) {
        this._initValue = initValue;
    }

    public void set(T ref) {
        if (ref == null) {
            throw new NullPointerException("Null value not allowed.");
        }
        if (this._volatileRef != null) {
            throw new IllegalStateException();
        }
        this._volatileRef = ref;
        this._unSafeRef = this._volatileRef;
    }

    public T get() {
        if (this._unSafeRef != null) {
            return this._unSafeRef;
        }
        this._unSafeRef = this._volatileRef;
        return this._unSafeRef == null ? this._initValue : this._unSafeRef;
    }
}

