/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.core.util;

import com.vmware.vim.binding.dataservice.accesscontrol.AccessControl;
import com.vmware.vim.binding.dataservice.accesscontrol.Principal;
import com.vmware.vim.binding.vmodl.DynamicData;
import com.vmware.vim.query.core.util.CompositeKeyRef;
import com.vmware.vim.query.core.util.ImmutableAbstract;
import com.vmware.vim.query.core.util.KeyBasedSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class AccessControlList
extends KeyBasedSet<AccessControl> {
    private static final long serialVersionUID = 1L;

    public AccessControlList() {
        super(AccessControl.class, AccessControlKey.INSTANCE);
    }

    protected AccessControlList(Map<Object, AccessControl> map) {
        super(AccessControl.class, AccessControlKey.INSTANCE, map);
    }

    static CompositeKeyRef<Principal> getCompositeKey(AccessControl t) {
        return new CompositeKeyRef<Principal>(t.getPrincipal(), t.getPrincipal().getName(), t.getPrincipal().isGroup());
    }

    public static AccessControlList immutable(Collection<AccessControl> input) {
        AccessControlList newCopy = new AccessControlList();
        for (AccessControl p : input) {
            newCopy.add(new ImmutablePermission(p));
        }
        return new AccessControlList(Collections.unmodifiableMap(newCopy._map));
    }

    static class ImmutablePrinciple
    extends ImmutableAbstract
    implements Principal {
        private static final long serialVersionUID = 1L;
        private final String _name;
        private final boolean _isGroup;

        ImmutablePrinciple(Principal p) {
            super((DynamicData)p);
            this._name = p.getName();
            this._isGroup = p.isGroup();
        }

        public String getName() {
            return this._name;
        }

        public boolean isGroup() {
            return this._isGroup;
        }

        public void setGroup(boolean arg0) {
            throw new UnsupportedOperationException();
        }

        public void setName(String arg0) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "ImmutablePrinciple [_name=" + this._name + ", _isGroup=" + this._isGroup + "]";
        }
    }

    public static class ImmutablePermission
    extends ImmutableAbstract
    implements AccessControl {
        private static final long serialVersionUID = 1L;
        private final Principal _principal;
        private final boolean _propogating;
        private final long[] _roles;
        private final long _version;

        public ImmutablePermission(AccessControl p) {
            super((DynamicData)p);
            this._principal = new ImmutablePrinciple(p.getPrincipal());
            this._roles = (long[])(p.getRoles() != null ? Arrays.copyOf(p.getRoles(), p.getRoles().length) : null);
            this._propogating = p.isPropagate();
            this._version = p.getVersion();
        }

        public Principal getPrincipal() {
            return this._principal;
        }

        public long[] getRoles() {
            if (this._roles == null) {
                return null;
            }
            return Arrays.copyOf(this._roles, this._roles.length);
        }

        public boolean isPropagate() {
            return this._propogating;
        }

        public void setPrincipal(Principal arg0) {
            throw new UnsupportedOperationException();
        }

        public void setPropagate(boolean arg0) {
            throw new UnsupportedOperationException();
        }

        public void setRoles(long[] arg0) {
            throw new UnsupportedOperationException();
        }

        public long getVersion() {
            return this._version;
        }

        public void setVersion(long arg0) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "ImmutablePermission [_principal=" + this._principal + ", _propogating=" + this._propogating + ", _roles=" + Arrays.toString(this._roles) + ", _version=" + this._version + "]";
        }
    }

    static enum AccessControlKey implements KeyBasedSet.GetKey<AccessControl>
    {
        INSTANCE;


        @Override
        public Object key(AccessControl k) {
            return AccessControlList.getCompositeKey(k);
        }
    }
}

