/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.core.util;

import com.vmware.vim.binding.dataservice.QName;
import com.vmware.vim.binding.dataservice.accesscontrol.Privilege;
import com.vmware.vim.binding.dataservice.accesscontrol.Role;
import com.vmware.vim.binding.impl.dataservice.QNameImpl;
import com.vmware.vim.query.core.util.ConstantFinder;
import com.vmware.vim.query.core.util.Helper;
import com.vmware.vim.query.core.util.KeyBasedSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class AclConstants {
    public static final String GLOBAL_PERMISSIONS_DOC_NAME = "urn:acl:global:permissions";
    public static final URI GLOBAL_PERMISSIONS;
    public static final String GLOBAL_PERMISSIONS_DOC_ENCODED;
    public static final String ACL = "acl";
    public static final String GLOBAL_PERMISSIONS_PRODUCT = "global_permissions";
    public static final String GLOBAL_PERMISSIONS_PROVIDER_UUID = "permissions";
    public static final String ACL_STORE = "acl-store";
    public static final String ACL_STORE_FEED = "acl-store feed";
    public static final String PERMISSION_GENERATION = "mg-permissions";
    public static final String PERMISSIONS = "permissions";
    public static final String GET_DOCUMENT;
    public static final String GET_PERMISSIONS_FOR_ALL_DOCUMENTS;
    public static final String GLOBAL_PERMISSIONS_DOC;
    public static final String GET_ALL_ACL_DOCUMENTS;
    public static final String TENANT_GLOBAL_PERMISSIONS_DOC;
    public static final QName TENANT_PERMISSION_PARENT_PROPERTY;
    public static final long MAX_SOLUTION_ROLE_ID = 4000L;
    public static final long ROLE_NO_ACCESS = -5L;
    public static final long ROLE_VIEW = -3L;
    public static final long ROLE_READ_ONLY = -2L;
    public static final long ROLE_ADMIN = -1L;
    public static final long ROLE_ANONYMOUS = -4L;
    public static final int MAX_PRIVILEGES = 1024;
    public static final Set<Long> BUILT_IN_ROLES_SET;
    public static final String PRIV_SYSTEM_VIEW = "System.View";
    public static final String PRIV_SYSTEM_READ = "System.Read";
    public static final String PRIV_SYSTEM_ANONYMOUS = "System.Anonymous";
    public static final String PRIV_SYSTEM = "System";
    public static final Set<String> BUILT_IN_PRIVILEGES_SET;

    private AclConstants() {
        assert (false);
    }

    static {
        try {
            GLOBAL_PERMISSIONS = new URI(GLOBAL_PERMISSIONS_DOC_NAME);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        GLOBAL_PERMISSIONS_DOC_ENCODED = Helper.encode(GLOBAL_PERMISSIONS_DOC_NAME);
        GET_DOCUMENT = ConstantFinder.getQuery("GET_DOCUMENT");
        GET_PERMISSIONS_FOR_ALL_DOCUMENTS = ConstantFinder.getQuery("GET_PERMISSIONS_FOR_ALL_DOCUMENTS");
        GLOBAL_PERMISSIONS_DOC = ConstantFinder.getQuery("GLOBAL_PERMISSIONS");
        GET_ALL_ACL_DOCUMENTS = ConstantFinder.getQuery("GET_ALL_ACL_DOCUMENTS");
        TENANT_GLOBAL_PERMISSIONS_DOC = ConstantFinder.getQuery("TENANT_GLOBAL_PERMISSIONS");
        TENANT_PERMISSION_PARENT_PROPERTY = new QNameImpl("urn:acl:global:permissions:ns", "parent");
        BUILT_IN_ROLES_SET = Collections.unmodifiableSet(new HashSet<Long>(Arrays.asList(-3L, -5L, -2L, -1L, -4L)));
        BUILT_IN_PRIVILEGES_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(PRIV_SYSTEM_VIEW, PRIV_SYSTEM_READ, PRIV_SYSTEM_ANONYMOUS)));
    }

    public static enum PrivilegeGetKey implements KeyBasedSet.GetKey<Privilege>
    {
        INSTANCE;


        @Override
        public Object key(Privilege k) {
            return k.getId();
        }
    }

    public static enum RoleGetKey implements KeyBasedSet.GetKey<Role>
    {
        INSTANCE;


        @Override
        public Object key(Role k) {
            return k.getId();
        }
    }
}

