/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cloudvm;

import com.vmware.vise.vim.cloudvm.CloudVmServiceException;
import com.vmware.vise.vim.cloudvm.CpuStats;
import com.vmware.vise.vim.cloudvm.DnsServerConfig;
import com.vmware.vise.vim.cloudvm.FirewallAddressRule;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.IPv6Config;
import com.vmware.vise.vim.cloudvm.LoadStats;
import com.vmware.vise.vim.cloudvm.MemStats;
import com.vmware.vise.vim.cloudvm.NetStats;
import com.vmware.vise.vim.cloudvm.NetworkInterfaceInfo;
import com.vmware.vise.vim.cloudvm.NetworkRoute;
import com.vmware.vise.vim.cloudvm.PowerOperationConfig;
import com.vmware.vise.vim.cloudvm.ShellConfig;
import com.vmware.vise.vim.cloudvm.StorageStats;
import com.vmware.vise.vim.cloudvm.SwapStats;
import com.vmware.vise.vim.cloudvm.SystemStats;
import com.vmware.vise.vim.commons.xmlrpc.XmlRpcClient;
import com.vmware.vise.vim.commons.xmlrpc.XmlRpcUtil;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;

public class CloudVmService {
    private static final String ERROR_MESSAGE_KEY = "message";
    private static final String ERROR_ATTRIBUTES_KEY = "attributes";
    private static final String ERROR_CODE_KEY = "code";
    private static final String ERROR_KEY = "__error__";
    private static final Log _logger = LogFactory.getLog(CloudVmService.class);
    private static final String GET_CONSOLE_CLI_ACCESS_ENABLED_METHOD = "com.vmware.appliance.version1.access.consolecli.get";
    private static final String SET_CONSOLE_CLI_ACCESS_ENABLED_METHOD = "com.vmware.appliance.version1.access.consolecli.set";
    private static final String GET_DCUI_ACCESS_ENABLED_METHOD = "com.vmware.appliance.version1.access.dcui.get";
    private static final String SET_DCUI_ACCESS_ENABLED_METHOD = "com.vmware.appliance.version1.access.dcui.set";
    private static final String GET_SHELL_ACCESS_CONFIG_METHOD = "com.vmware.appliance.version1.access.shell.get";
    private static final String SET_SHELL_ACCESS_CONFIG_METHOD = "com.vmware.appliance.version1.access.shell.set";
    private static final String GET_SSH_ACCESS_ENABLED_METHOD = "com.vmware.appliance.version1.access.ssh.get";
    private static final String SET_SSH_ACCESS_ENABLED_METHOD = "com.vmware.appliance.version1.access.ssh.set";
    private static final String LIST_DNS_DOMAINS_METHOD = "com.vmware.appliance.version1.networking.dns.domains.list";
    private static final String SET_DNS_DOMAINS_METHOD = "com.vmware.appliance.version1.networking.dns.domains.set";
    private static final String ADD_DNS_DOMAINS_METHOD = "com.vmware.appliance.version1.networking.dns.domains.add";
    private static final String GET_DNS_SERVERS_METHOD = "com.vmware.appliance.version1.networking.dns.servers.get";
    private static final String SET_DNS_SERVERS_METHOD = "com.vmware.appliance.version1.networking.dns.servers.set";
    private static final String ADD_DNS_SERVERS_METHOD = "com.vmware.appliance.version1.networking.dns.servers.add";
    private static final String GET_HOST_NAME_METHOD = "com.vmware.appliance.version1.networking.dns.hostname.get";
    private static final String SET_HOST_NAME_METHOD = "com.vmware.appliance.version1.networking.dns.hostname.set";
    private static final String GET_NIC_METHOD = "com.vmware.appliance.version1.networking.interfaces.get";
    private static final String LIST_NICS_METHOD = "com.vmware.appliance.version1.networking.interfaces.list";
    private static final String GET_IPV4_CONFIG_METHOD = "com.vmware.appliance.version1.networking.ipv4.get";
    private static final String LIST_IPV4_CONFIG_METHOD = "com.vmware.appliance.version1.networking.ipv4.list";
    private static final String SET_IPV4_CONFIG_METHOD = "com.vmware.appliance.version1.networking.ipv4.set";
    private static final String RENEW_IPV4_CONFIG_METHOD = "com.vmware.appliance.version1.networking.ipv4.renew";
    private static final String GET_IPV6_CONFIG_METHOD = "com.vmware.appliance.version1.networking.ipv6.get";
    private static final String LIST_IPV6_CONFIG_METHOD = "com.vmware.appliance.version1.networking.ipv6.list";
    private static final String SET_IPV6_CONFIG_METHOD = "com.vmware.appliance.version1.networking.ipv6.set";
    private static final String ADD_FIREWALL_ADDRESS_RULE_METHOD = "com.vmware.appliance.version1.networking.firewall.addr.inbound.add";
    private static final String LIST_FIREWALL_ADDRESS_RULE_METHOD = "com.vmware.appliance.version1.networking.firewall.addr.inbound.list";
    private static final String SET_FIREWALL_ADDRESS_RULE_METHOD = "com.vmware.appliance.version1.networking.firewall.addr.inbound.set";
    private static final String LIST_NETWORK_ROUTES_METHOD = "com.vmware.appliance.version1.networking.routes.list";
    private static final String SET_NETWORK_ROUTES_METHOD = "com.vmware.appliance.version1.networking.routes.set";
    private static final String GET_SYSTEM_STATS_METHOD = "com.vmware.appliance.version1.resources.system.stats.get";
    private static final String GET_CPU_STATS_METHOD = "com.vmware.appliance.version1.resources.cpu.stats.get";
    private static final String GET_MEM_STATS_METHOD = "com.vmware.appliance.version1.resources.mem.stats.get";
    private static final String GET_LOAD_STATS_METHOD = "com.vmware.appliance.version1.resources.load.stats.get";
    private static final String GET_NET_STATS_METHOD = "com.vmware.appliance.version1.resources.net.stats.get";
    private static final String LIST_NET_STATS_METHOD = "com.vmware.appliance.version1.resources.net.stats.list";
    private static final String GET_SWAP_STATS_METHOD = "com.vmware.appliance.version1.resources.swap.stats.get";
    private static final String LIST_STORAGE_STATS_METHOD = "com.vmware.appliance.version1.resources.storage.stats.list";
    private static final String GET_SYSTEM_HEALTH_METHOD = "com.vmware.appliance.version1.resources.system.health.get";
    private static final String GET_STORAGE_HEALTH_METHOD = "com.vmware.appliance.version1.resources.storage.health.get";
    private static final String GET_MEM_HEALTH_METHOD = "com.vmware.appliance.version1.resources.mem.health.get";
    private static final String GET_LOAD_HEALTH_METHOD = "com.vmware.appliance.version1.resources.load.health.get";
    private static final String GET_SWAP_HEALTH_METHOD = "com.vmware.appliance.version1.resources.swap.health.get";
    private static final String SERVICES_CONTROL_METHOD = "com.vmware.appliance.version1.services.control";
    private static final String APPLIANCE_SHUTDOWN_METHOD = "com.vmware.appliance.version1.shutdown.poweroff";
    private static final String APPLIANCE_RESTART_METHOD = "com.vmware.appliance.version1.shutdown.reboot";
    private XmlRpcClient _client;

    public CloudVmService(XmlRpcClient xmlRpcClient) {
        this._client = xmlRpcClient;
    }

    public boolean isConsoleCliEnabled() throws CloudVmServiceException {
        return (Boolean)this.get(GET_CONSOLE_CLI_ACCESS_ENABLED_METHOD, new Object[0]);
    }

    public void setConsoleCliEnabled(boolean bl) throws CloudVmServiceException {
        this.set(SET_CONSOLE_CLI_ACCESS_ENABLED_METHOD, bl);
    }

    public boolean isDcuiEnabled() throws CloudVmServiceException {
        return (Boolean)this.get(GET_DCUI_ACCESS_ENABLED_METHOD, new Object[0]);
    }

    public void setDcuiEnabled(boolean bl) throws CloudVmServiceException {
        this.set(SET_DCUI_ACCESS_ENABLED_METHOD, bl);
    }

    public ShellConfig getShellConfig() throws CloudVmServiceException {
        return ShellConfig.fromParam((Map)this.get(GET_SHELL_ACCESS_CONFIG_METHOD, new Object[0]));
    }

    public void setShellConfig(ShellConfig shellConfig) throws CloudVmServiceException {
        this.set(SET_SHELL_ACCESS_CONFIG_METHOD, shellConfig.toParam());
    }

    public boolean isSshEnabled() throws CloudVmServiceException {
        return (Boolean)this.get(GET_SSH_ACCESS_ENABLED_METHOD, new Object[0]);
    }

    public void setSshEnabled(boolean bl) throws CloudVmServiceException {
        this.set(SET_SSH_ACCESS_ENABLED_METHOD, bl);
    }

    public String[] listDnsDomains() throws CloudVmServiceException {
        return this.toStringArray((Object[])this.get(LIST_DNS_DOMAINS_METHOD, new Object[0]));
    }

    public void setDnsDomains(String[] stringArray) throws CloudVmServiceException {
        this.set(SET_DNS_DOMAINS_METHOD, new Object[]{stringArray});
    }

    public void addDnsDomains(String string) throws CloudVmServiceException {
        this.set(ADD_DNS_DOMAINS_METHOD, string);
    }

    public String getHostname() throws CloudVmServiceException {
        return (String)this.get(GET_HOST_NAME_METHOD, new Object[0]);
    }

    public void setHostname(String string) throws CloudVmServiceException {
        this.set(SET_HOST_NAME_METHOD, string);
    }

    public DnsServerConfig getDnsServersConfig() throws CloudVmServiceException {
        return DnsServerConfig.fromParam((Map)this.get(GET_DNS_SERVERS_METHOD, new Object[0]));
    }

    public void setDnsServersConfig(DnsServerConfig dnsServerConfig) throws CloudVmServiceException {
        this.set(SET_DNS_SERVERS_METHOD, dnsServerConfig.toParam());
    }

    public void addDnsServersConfig(String string) throws CloudVmServiceException {
        this.set(ADD_DNS_SERVERS_METHOD, string);
    }

    public NetworkInterfaceInfo getNic(String string) throws CloudVmServiceException {
        return NetworkInterfaceInfo.fromParam((Map)this.get(GET_NIC_METHOD, string));
    }

    public NetworkInterfaceInfo[] listNics() throws CloudVmServiceException {
        return NetworkInterfaceInfo.fromArray((Object[])this.get(LIST_NICS_METHOD, new Object[0]));
    }

    public IPv4Config[] getIPv4Config(String[] stringArray) throws CloudVmServiceException {
        return IPv4Config.fromArray((Object[])this.get(GET_IPV4_CONFIG_METHOD, new Object[]{stringArray}));
    }

    public IPv4Config[] listIPv4Config() throws CloudVmServiceException {
        return IPv4Config.fromArray((Object[])this.get(LIST_IPV4_CONFIG_METHOD, new Object[0]));
    }

    public void setIPv4Config(IPv4Config[] iPv4ConfigArray) throws CloudVmServiceException {
        this.set(SET_IPV4_CONFIG_METHOD, new Object[]{IPv4Config.toParamArray(iPv4ConfigArray)});
    }

    public void renewIPv4Config(String[] stringArray) throws CloudVmServiceException {
        this.set(RENEW_IPV4_CONFIG_METHOD, new Object[]{stringArray});
    }

    public IPv6Config[] getIPv6Config(String[] stringArray) throws CloudVmServiceException {
        return IPv6Config.fromArray((Object[])this.get(GET_IPV6_CONFIG_METHOD, new Object[]{stringArray}));
    }

    public void setIPv6Config(IPv6Config[] iPv6ConfigArray) throws CloudVmServiceException {
        this.set(SET_IPV6_CONFIG_METHOD, new Object[]{IPv6Config.toParamArray(iPv6ConfigArray)});
    }

    public IPv6Config[] listIPv6Config() throws CloudVmServiceException {
        return IPv6Config.fromArray((Object[])this.get(LIST_IPV6_CONFIG_METHOD, new Object[0]));
    }

    public FirewallAddressRule[] listFirewallRules() throws CloudVmServiceException {
        return FirewallAddressRule.fromArray((Object[])this.get(LIST_FIREWALL_ADDRESS_RULE_METHOD, new Object[0]));
    }

    public void setFirewallRules(FirewallAddressRule[] firewallAddressRuleArray) throws CloudVmServiceException {
        this.set(SET_FIREWALL_ADDRESS_RULE_METHOD, new Object[]{FirewallAddressRule.toParamArray(firewallAddressRuleArray)});
    }

    public void addFirewallRule(int n, FirewallAddressRule firewallAddressRule) throws CloudVmServiceException {
        this.set(ADD_FIREWALL_ADDRESS_RULE_METHOD, n, firewallAddressRule.toParam());
    }

    public NetworkRoute[] listRoutes() throws CloudVmServiceException {
        return NetworkRoute.fromArray((Object[])this.get(LIST_NETWORK_ROUTES_METHOD, new Object[0]));
    }

    public void setRoutes(NetworkRoute[] networkRouteArray) throws CloudVmServiceException {
        this.set(SET_NETWORK_ROUTES_METHOD, new Object[]{NetworkRoute.toParamArray(networkRouteArray)});
    }

    public String getSystemHealth() throws CloudVmServiceException {
        return (String)this.get(GET_SYSTEM_HEALTH_METHOD, new Object[0]);
    }

    public String getStorageHealth() throws CloudVmServiceException {
        return (String)this.get(GET_STORAGE_HEALTH_METHOD, new Object[0]);
    }

    public String getMemHealth() throws CloudVmServiceException {
        return (String)this.get(GET_MEM_HEALTH_METHOD, new Object[0]);
    }

    public String getLoadHealth() throws CloudVmServiceException {
        return (String)this.get(GET_LOAD_HEALTH_METHOD, new Object[0]);
    }

    public String getSwapHealth() throws CloudVmServiceException {
        return (String)this.get(GET_SWAP_HEALTH_METHOD, new Object[0]);
    }

    public SystemStats getSystemStats() throws CloudVmServiceException {
        return SystemStats.fromParam((Map)this.get(GET_SYSTEM_STATS_METHOD, new Object[0]));
    }

    public CpuStats getCpuStats() throws CloudVmServiceException {
        return CpuStats.fromParam((Map)this.get(GET_CPU_STATS_METHOD, new Object[0]));
    }

    public MemStats getMemStats() throws CloudVmServiceException {
        return MemStats.fromParam((Map)this.get(GET_MEM_STATS_METHOD, new Object[0]));
    }

    public SwapStats getSwapStats() throws CloudVmServiceException {
        return SwapStats.fromParam((Map)this.get(GET_SWAP_STATS_METHOD, new Object[0]));
    }

    public LoadStats getLoadStats() throws CloudVmServiceException {
        return LoadStats.fromParam((Map)this.get(GET_LOAD_STATS_METHOD, new Object[0]));
    }

    public NetStats getNetStats(String string) throws CloudVmServiceException {
        return NetStats.fromParam((Map)this.get(GET_NET_STATS_METHOD, string));
    }

    public NetStats[] listNetStats() throws CloudVmServiceException {
        return NetStats.fromArray((Object[])this.get(LIST_NET_STATS_METHOD, new Object[0]));
    }

    public StorageStats[] listStorageStats() throws CloudVmServiceException {
        return StorageStats.fromArray((Object[])this.get(LIST_STORAGE_STATS_METHOD, new Object[0]));
    }

    public String control(String string, String[] stringArray, int n) throws CloudVmServiceException {
        return (String)this.get(SERVICES_CONTROL_METHOD, string, stringArray, n);
    }

    public void restart(PowerOperationConfig powerOperationConfig) throws CloudVmServiceException {
        this.set(APPLIANCE_RESTART_METHOD, powerOperationConfig.toParam());
    }

    public void shutdown(PowerOperationConfig powerOperationConfig) throws CloudVmServiceException {
        this.set(APPLIANCE_SHUTDOWN_METHOD, powerOperationConfig.toParam());
    }

    private Object get(String string, Object ... objectArray) throws CloudVmServiceException {
        Object object = null;
        try {
            _logger.debug((Object)("calling " + string + "()"));
            object = this._client.execute(string, objectArray);
        }
        catch (XmlRpcException xmlRpcException) {
            _logger.error((Object)("Error while calling method " + string), (Throwable)xmlRpcException);
            throw new CloudVmServiceException(xmlRpcException);
        }
        if (!(object instanceof Map)) {
            return object;
        }
        this.throwIfError(string, object);
        return XmlRpcUtil.extractSingleResult((Object)object);
    }

    private void set(String string, Object ... objectArray) throws CloudVmServiceException {
        Object object = null;
        try {
            _logger.debug((Object)("Calling " + string + "()"));
            object = this._client.execute(string, objectArray);
        }
        catch (XmlRpcException xmlRpcException) {
            _logger.error((Object)("Error while calling method " + string), (Throwable)xmlRpcException);
            throw new CloudVmServiceException(xmlRpcException);
        }
        this.throwIfError(string, object);
    }

    private String[] toStringArray(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    private void throwIfError(String string, Object object) throws CloudVmServiceException {
        assert (object instanceof Map);
        Map map = (Map)object;
        if (map.containsKey(ERROR_KEY) && ((Boolean)map.get(ERROR_KEY)).booleanValue()) {
            String string2 = (String)map.get(ERROR_MESSAGE_KEY);
            if (map.containsKey(ERROR_ATTRIBUTES_KEY)) {
                string2 = string2 + "\n Details: " + map.get(ERROR_ATTRIBUTES_KEY).toString();
            }
            int n = map.containsKey(ERROR_CODE_KEY) ? XmlRpcUtil.getInt((Map)map, (String)ERROR_CODE_KEY) : 0;
            throw new CloudVmServiceException(string + ": " + string2, n);
        }
    }
}

