/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cloudvm.impl;

import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cloudvm.CloudVmService;
import com.vmware.vise.vim.cloudvm.CloudVmServiceManager;
import com.vmware.vise.vim.cloudvm.impl.CloudVmXmlRpcClient;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.xmlrpc.XmlRpcClient;
import com.vmware.vise.vim.security.sso.SsoService;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CloudVmServiceManagerImpl
implements CloudVmServiceManager {
    private static final Log _logger = LogFactory.getLog(CloudVmServiceManagerImpl.class);
    private final KeystoreService _ksService;
    private final SsoService _ssoService;

    public CloudVmServiceManagerImpl(SsoService ssoService, KeystoreService keystoreService) {
        this._ssoService = ssoService;
        this._ksService = keystoreService;
    }

    @Override
    public CloudVmService getService(URL uRL) {
        String string = CloudVmServiceManagerImpl.getSessionKey(uRL);
        CloudVmService cloudVmService = (CloudVmService)SessionUtil.getData((String)string);
        if (cloudVmService != null) {
            return cloudVmService;
        }
        try {
            XmlRpcClient xmlRpcClient = this.createXmlRpcClient(uRL);
            cloudVmService = new CloudVmService(xmlRpcClient);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            throw new RuntimeException(exception);
        }
        SessionUtil.setDataIfAbsent((String)string, (Object)cloudVmService);
        return cloudVmService;
    }

    private XmlRpcClient createXmlRpcClient(URL uRL) throws MalformedURLException {
        CloudVmXmlRpcClient cloudVmXmlRpcClient = new CloudVmXmlRpcClient(this._ssoService, this._ksService.getKeyStore(), uRL, true);
        return cloudVmXmlRpcClient;
    }

    private static String getSessionKey(URL uRL) {
        return "applmgmt-" + uRL;
    }
}

