/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm;

import com.vmware.cis.cm.common.endpoint.HealthStatusEndPoint;
import com.vmware.cis.cm.common.endpoint.HealthStatusServlet;
import com.vmware.cis.services.common.sso.NonRefetchingStsCertManagerImpl;
import com.vmware.cis.services.common.sso.StsCertManager;
import com.vmware.vise.vim.security.sso.SsoService;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.HttpRequestHandler;

public class HealthStatusRequestHandler
implements HttpRequestHandler {
    private SsoService _ssoService;
    private AtomicReference<HealthStatusServlet> _servletReference = new AtomicReference();

    public HealthStatusRequestHandler(SsoService ssoService) {
        this._ssoService = ssoService;
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HealthStatusServlet healthStatusServlet = this.getServlet();
        healthStatusServlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private HealthStatusServlet getServlet() {
        HealthStatusServlet healthStatusServlet = this._servletReference.get();
        if (healthStatusServlet != null) {
            return healthStatusServlet;
        }
        if (this._ssoService == null) {
            healthStatusServlet = HealthStatusEndPoint.createServlet((StsCertManager)null, null);
            this._servletReference.compareAndSet(null, healthStatusServlet);
            return this._servletReference.get();
        }
        X509Certificate[] x509CertificateArray = this._ssoService.getStsCertificates();
        List<X509Certificate> list = null;
        if (x509CertificateArray != null) {
            list = Arrays.asList(x509CertificateArray);
        }
        healthStatusServlet = HealthStatusEndPoint.createServlet((StsCertManager)new NonRefetchingStsCertManagerImpl(list));
        this._servletReference.compareAndSet(null, healthStatusServlet);
        return this._servletReference.get();
    }
}

