/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm;

import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.i18n.CatalogEntry;
import com.vmware.vise.vim.commons.i18n.MessageResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class LocalizedMessageDictionary {
    private static final Log _logger = LogFactory.getLog(LocalizedMessageDictionary.class);
    private final String _localeSessionDataKey;
    private final Locale _defaultLocale;
    private final ConcurrentMap<Locale, ConcurrentMap<String, CatalogEntry>> _propertyDictionaryByLocale = new ConcurrentHashMap<Locale, ConcurrentMap<String, CatalogEntry>>();

    LocalizedMessageDictionary(String string, Locale locale) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, locale});
        this._localeSessionDataKey = string;
        this._defaultLocale = locale;
    }

    Map<String, String> getLocalizedMessages(String[] stringArray, KeyAnyValue[][] keyAnyValueArray, Locale locale) {
        Map map;
        this.validateParams(stringArray, keyAnyValueArray);
        if (locale == null) {
            locale = (Locale)SessionUtil.getData((String)this._localeSessionDataKey);
        }
        if (locale == null) {
            locale = this._defaultLocale;
        }
        map = (map = (Map)this._propertyDictionaryByLocale.get(locale)) == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        MessageResolver messageResolver = new MessageResolver(map, locale);
        MessageResolver messageResolver2 = null;
        if (!locale.equals(this._defaultLocale)) {
            map = (Map)this._propertyDictionaryByLocale.get(this._defaultLocale);
            map = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
            messageResolver2 = new MessageResolver(map, null);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (keyAnyValueArray == null) {
                string = messageResolver.getLocalizedMessage(stringArray[i], null);
                if (string == null && messageResolver2 != null) {
                    string = messageResolver2.getLocalizedMessage(stringArray[i], null);
                }
            } else {
                string = messageResolver.getLocalizedMessage(stringArray[i], keyAnyValueArray[i]);
                if (string == null && messageResolver2 != null) {
                    string = messageResolver2.getLocalizedMessage(stringArray[i], keyAnyValueArray[i]);
                }
            }
            if (string == null) {
                string = stringArray[i];
            }
            hashMap.put(stringArray[i], StringUtil.trimQuotes((String)string));
        }
        return hashMap;
    }

    private void validateParams(String[] stringArray, KeyAnyValue[][] keyAnyValueArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("keys is required");
        }
        if (keyAnyValueArray != null) {
            for (KeyAnyValue[] keyAnyValueArray2 : keyAnyValueArray) {
                if (keyAnyValueArray2 != null) continue;
                throw new IllegalArgumentException("Cannot pass null member within args.");
            }
            if (stringArray.length != keyAnyValueArray.length) {
                throw new IllegalArgumentException("keys array length must match args array length.");
            }
        }
    }

    String getLocalizedMessage(Locale locale, String string, KeyAnyValue[] keyAnyValueArray) {
        if (locale == null || string == null) {
            return null;
        }
        MessageResolver messageResolver = null;
        Map map = (Map)this._propertyDictionaryByLocale.get(locale);
        if (map != null) {
            messageResolver = new MessageResolver(map = Collections.unmodifiableMap(map), locale);
            String string2 = messageResolver.getLocalizedMessage(string, keyAnyValueArray);
            if (string2 != null) {
                string2 = StringUtil.trimQuotes((String)string2);
            }
            return string2;
        }
        return null;
    }

    void loadProperties(String string, Locale locale, List<String> list) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, locale, list});
        for (String string2 : list) {
            String string3 = string + "/" + string2 + ":" + locale.getCountry();
            long l = System.currentTimeMillis();
            ResourceBundle resourceBundle = LocalizedMessageDictionary.loadResourceBundle(string, locale, string2);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Time loading ResourceBundle (ms) " + string3 + ": " + (System.currentTimeMillis() - l)));
            }
            l = System.currentTimeMillis();
            if (resourceBundle != null) {
                int n = this.loadValuesIntoDictionary(string3, resourceBundle, locale);
                _logger.info((Object)("Loaded " + n + " elements from bundle: " + string3));
            } else {
                _logger.warn((Object)("Failed to loading resource bundle: " + string3));
            }
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug((Object)("Time to load elements (ms) " + string3 + ": " + (System.currentTimeMillis() - l)));
        }
    }

    private int loadValuesIntoDictionary(String string, ResourceBundle resourceBundle, Locale locale) {
        Object object;
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)this._propertyDictionaryByLocale.get(locale);
        if (concurrentHashMap == null && (object = (ConcurrentMap)this._propertyDictionaryByLocale.putIfAbsent(locale, concurrentHashMap = new ConcurrentHashMap())) != null) {
            concurrentHashMap = object;
        }
        object = resourceBundle.getKeys();
        int n = 0;
        ArrayList<CatalogEntry> arrayList = new ArrayList<CatalogEntry>();
        ArrayList<CatalogEntry> arrayList2 = new ArrayList<CatalogEntry>();
        while (object.hasMoreElements()) {
            CatalogEntry catalogEntry;
            String string2 = (String)object.nextElement();
            CatalogEntry catalogEntry2 = concurrentHashMap.put(string2, catalogEntry = new CatalogEntry(string2, resourceBundle.getString(string2), string));
            if (catalogEntry2 != null) {
                if (ObjectUtil.objectsEqual((Object)catalogEntry2.getValue(), (Object)catalogEntry.getValue())) {
                    arrayList.add(catalogEntry2);
                } else {
                    arrayList2.add(catalogEntry2);
                }
            }
            ++n;
        }
        this.logConflictingEntries(string, arrayList2, arrayList);
        return n;
    }

    private void logConflictingEntries(String string, List<CatalogEntry> list, List<CatalogEntry> list2) {
        int n = list.size() + list2.size();
        if (n == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append(" Resource Bundle entry conflicts found for: ");
        stringBuilder.append(string);
        if (!_logger.isDebugEnabled()) {
            _logger.warn((Object)stringBuilder.toString());
            return;
        }
        stringBuilder.append('\n');
        for (CatalogEntry catalogEntry : list) {
            stringBuilder.append("key: ");
            stringBuilder.append(catalogEntry.getKey());
            stringBuilder.append("overwrote the entry from bundle: ");
            stringBuilder.append(catalogEntry.getSourceId());
            stringBuilder.append(", previous value: ");
            stringBuilder.append(catalogEntry.getValue());
            stringBuilder.append('\n');
        }
        for (CatalogEntry catalogEntry : list2) {
            stringBuilder.append("key: ");
            stringBuilder.append(catalogEntry.getKey());
            stringBuilder.append(" duplicated with same value in bundle: ");
            stringBuilder.append(catalogEntry.getSourceId());
            stringBuilder.append('\n');
        }
        _logger.debug((Object)stringBuilder.toString());
    }

    private static ResourceBundle loadResourceBundle(String string, Locale locale, String string2) {
        if (string == null || locale == null || string2 == null) {
            return null;
        }
        URL uRL = null;
        try {
            File file = new File(string);
            uRL = file.toURI().toURL();
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL});
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, locale, uRLClassLoader, new UTF8Control());
            _logger.info((Object)("Loaded Resource bundle " + string2));
            return resourceBundle;
        }
        catch (MissingResourceException missingResourceException) {
            _logger.warn((Object)("Failed to get the resource bundle for locale " + locale.toString() + missingResourceException));
        }
        catch (IOException iOException) {
            _logger.error((Object)iOException);
        }
        return null;
    }

    private static class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            String string3 = this.toBundleName(string, locale);
            String string4 = this.toResourceName(string3, "properties");
            PropertyResourceBundle propertyResourceBundle = null;
            InputStream inputStream = null;
            if (bl) {
                URLConnection uRLConnection;
                URL uRL = classLoader.getResource(string4);
                if (uRL != null && (uRLConnection = uRL.openConnection()) != null) {
                    uRLConnection.setUseCaches(false);
                    inputStream = uRLConnection.getInputStream();
                }
            } else {
                inputStream = classLoader.getResourceAsStream(string4);
            }
            if (inputStream != null) {
                try {
                    propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(inputStream, "UTF-8"));
                }
                finally {
                    inputStream.close();
                }
            }
            return propertyResourceBundle;
        }
    }
}

