/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm.healthstatus;

import com.vmware.vim.binding.cis.cm.monitor.HealthStatus;
import com.vmware.vim.binding.impl.vmodl.LocalizableMessageImpl;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vise.vim.cm.healthstatus.WebClientHealthStatus;
import com.vmware.vise.vim.cm.healthstatus.WebClientHealthStatusService;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class AppServerHealthService
implements WebClientHealthStatusService {
    private double _memoryThreshold = 0.9;

    @Override
    public WebClientHealthStatus getStatus() {
        WebClientHealthStatus webClientHealthStatus = this.getMemoryStatus();
        return webClientHealthStatus;
    }

    private WebClientHealthStatus getMemoryStatus() {
        Object object;
        HealthStatus.Code code = null;
        LocalizableMessage[] localizableMessageArray = null;
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        double d = (double)memoryUsage.getUsed() / (double)memoryUsage.getMax();
        if (d > this._memoryThreshold) {
            code = HealthStatus.Code.YELLOW;
            object = new LocalizableMessageImpl();
            object.setKey("webclient.memory.lowheap");
            localizableMessageArray = new LocalizableMessage[]{object};
        } else {
            code = HealthStatus.Code.GREEN;
        }
        object = new WebClientHealthStatus(code, localizableMessageArray);
        return object;
    }
}

