/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm.impl;

import com.vmware.af.VmAfClient;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.cm.impl.ComponentManagerSource;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AfdCMSource
extends ComponentManagerSource {
    private static final Log _logger = LogFactory.getLog(AfdCMSource.class);
    private static final String AFD_DISABLED = "afd.disabled";
    private URI _serviceUri;

    public AfdCMSource(KeystoreService keystoreService) {
        super(keystoreService);
    }

    @Override
    public synchronized URI getServiceUri() {
        if (this._serviceUri == null) {
            this._serviceUri = this.getCMUrl();
        }
        return this._serviceUri;
    }

    public static ComponentManagerSource tryCreate(ConfigurationService configurationService, KeystoreService keystoreService) {
        AfdCMSource afdCMSource = null;
        boolean bl = Boolean.parseBoolean(configurationService.getProperty(AFD_DISABLED));
        if (!bl) {
            afdCMSource = new AfdCMSource(keystoreService);
        }
        return afdCMSource;
    }

    private URI getCMUrl() {
        String string = null;
        try {
            String string2 = "localhost";
            _logger.info((Object)("Creating vm afd client at " + string2));
            VmAfClient vmAfClient = new VmAfClient(string2);
            string = vmAfClient.getCMLocation();
            _logger.info((Object)("CM location from afd: " + string));
            URI uRI = AfdCMSource.toServiceUri(string.trim());
            return uRI;
        }
        catch (Error error) {
            _logger.error((Object)"Error when talking to afd client", (Throwable)error);
            return null;
        }
    }
}

