/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm.impl;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vise.extensionfw.ExtensionFilter;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.ZipUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.common.Environment;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cm.ComponentManagerConnectionException;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.extension.util.VcExtensionUtil;
import com.vmware.vise.vim.internal.Config;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmExtensionManager
implements UserSessionListener,
ExtensionFilter,
ExtensionListener {
    private static final Log _logger = LogFactory.getLog(CmExtensionManager.class);
    private static final String PLUGIN_ENDPOINT_TYPE_ID = "com.vmware.cis.vsphereclient.plugin";
    @Nonnull
    private final ComponentManagerService _cmService;
    @Nullable
    private final SearchCriteria _criteria;
    @Nonnull
    private final ExtensionService _extensionService;
    @Nullable
    private final ConfigurationService _configurationService;
    @Nullable
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private static final String SESSION_PACKAGES_REFS = "cmPackagesRefs";
    private Set<IdVersionPair> _registeredPackageRefs = new HashSet<IdVersionPair>();
    private ConcurrentMap<File, Object> _lockByPackageDir = new ConcurrentHashMap<File, Object>();
    private static final String POOL_NAME = "cm-extension-manager-pool";
    private static final ExecutorService EXECUTOR = ThreadPoolFactory.newQueingCachedThreadPool((int)10, (ThreadFactory)new WorkerThreadFactory("cm-extension-manager-pool"), (long)10L, (TimeUnit)TimeUnit.SECONDS, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);

    public CmExtensionManager(ExtensionService extensionService, ComponentManagerService componentManagerService, ConfigurationService configurationService) {
        this(false, extensionService, componentManagerService, configurationService, null);
    }

    public CmExtensionManager(@Nonnull ExtensionService extensionService, @Nonnull ComponentManagerService componentManagerService, @Nullable ConfigurationService configurationService, @Nonnull SSLConfigurationProvider sSLConfigurationProvider) {
        this(true, (ExtensionService)ValidationUtil.notNull((Object)extensionService, (String)"extensionService is null"), (ComponentManagerService)ValidationUtil.notNull((Object)componentManagerService, (String)"cmService is null"), configurationService, (SSLConfigurationProvider)ValidationUtil.notNull((Object)sSLConfigurationProvider, (String)"sslConfigurationProvider is null"));
    }

    private CmExtensionManager(boolean bl, ExtensionService extensionService, ComponentManagerService componentManagerService, ConfigurationService configurationService, SSLConfigurationProvider sSLConfigurationProvider) {
        SearchCriteriaImpl searchCriteriaImpl;
        this._extensionService = extensionService;
        this._cmService = componentManagerService;
        this._configurationService = configurationService;
        this._sslConfigurationProvider = sSLConfigurationProvider;
        try {
            searchCriteriaImpl = new SearchCriteriaImpl();
            ServiceEndPointTypeImpl serviceEndPointTypeImpl = new ServiceEndPointTypeImpl();
            serviceEndPointTypeImpl.setEndPointProtocol(ServiceEndPointType.EndPointProtocol.http.toString());
            serviceEndPointTypeImpl.setTypeId(PLUGIN_ENDPOINT_TYPE_ID);
            searchCriteriaImpl.setEndPointType((ServiceEndPointType)serviceEndPointTypeImpl);
        }
        catch (Exception exception) {
            searchCriteriaImpl = null;
        }
        this._criteria = searchCriteriaImpl;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        String string = httpSessionEvent.getSession().getId();
        _logger.debug((Object)("Component Manager Extensions session init start " + string));
        try {
            ServiceInfo[] serviceInfoArray = this._cmService.search(this._criteria);
            List<CMPackageInfo> list = this.getCMPackages(serviceInfoArray);
            Set<IdVersionPair> set = this.addPackages(list);
            if (!set.isEmpty()) {
                SessionUtil.setData((String)SESSION_PACKAGES_REFS, set, (HttpSession)httpSessionEvent.getSession());
            }
        }
        catch (ComponentManagerConnectionException componentManagerConnectionException) {
            _logger.error((Object)("Error when fetching vSphere Client plugins from Component Manager. - " + componentManagerConnectionException.getMessage()));
            throw componentManagerConnectionException;
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when fetching vSphere Client plugins from Component Manager (SSO may be disabled). ", (Throwable)exception);
        }
        _logger.debug((Object)("Component Manager Extensions session init complete " + string));
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        if (!pluginPackageEvent.getType().equals("pluginPackageUndeployed")) {
            return;
        }
        for (PluginPackageInfo pluginPackageInfo : pluginPackageEvent.getPluginPackageInfos()) {
            this.packageUndeployed(pluginPackageInfo.getPackageRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterPackages(Set<IdVersionPair> set) {
        Set set2 = (Set)SessionUtil.getData((String)SESSION_PACKAGES_REFS);
        Iterator<IdVersionPair> iterator = set.iterator();
        while (iterator.hasNext()) {
            IdVersionPair idVersionPair = iterator.next();
            Set<IdVersionPair> set3 = this._registeredPackageRefs;
            synchronized (set3) {
                if (!this._registeredPackageRefs.contains(idVersionPair)) {
                    continue;
                }
            }
            if (set2 != null && set2.contains(idVersionPair)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packageUndeployed(IdVersionPair idVersionPair) {
        Object object;
        Object object2 = this._registeredPackageRefs;
        synchronized (object2) {
            this._registeredPackageRefs.remove(idVersionPair);
        }
        object2 = this.getPackageDir(idVersionPair);
        Object object3 = object = this.getPackageDirLock((File)object2);
        synchronized (object3) {
            try {
                if (((File)object2).exists()) {
                    _logger.info((Object)("Delete Component Manager package directory '" + object2 + "' because the package is undeployed."));
                    FileUtil.deleteDir((File)object2);
                }
            }
            finally {
                this.removePackageDirLock((File)object2);
            }
        }
    }

    private List<CMPackageInfo> getCMPackages(ServiceInfo[] serviceInfoArray) {
        ArrayList<CMPackageInfo> arrayList = new ArrayList<CMPackageInfo>();
        if (serviceInfoArray == null || serviceInfoArray.length == 0) {
            return arrayList;
        }
        for (ServiceInfo serviceInfo : serviceInfoArray) {
            if (serviceInfo.getServiceEndPoints() == null || serviceInfo.getServiceEndPoints().length == 0) continue;
            if (serviceInfo.getServiceType() == null) {
                _logger.error((Object)("Component manager extension '" + serviceInfo.getServiceId() + "' has empty service type, skip."));
                continue;
            }
            CMPackageInfo cMPackageInfo = new CMPackageInfo();
            String string = serviceInfo.getServiceType().getProductId() + "." + serviceInfo.getServiceType().getTypeId();
            cMPackageInfo.setId(string);
            cMPackageInfo.setVersion(serviceInfo.getServiceVersion());
            cMPackageInfo.setName(serviceInfo.getServiceNameResourceKey());
            cMPackageInfo.setDescription(serviceInfo.getServiceDescriptionResourceKey());
            for (ServiceEndPoint serviceEndPoint : serviceInfo.getServiceEndPoints()) {
                if (serviceEndPoint.getEndPointType() == null || !PLUGIN_ENDPOINT_TYPE_ID.equals(serviceEndPoint.getEndPointType().getTypeId())) continue;
                cMPackageInfo.url = serviceEndPoint.getUrl().toString();
                if (serviceEndPoint.getSslTrust() == null || serviceEndPoint.getSslTrust().length <= 0) continue;
                cMPackageInfo.certificate = serviceEndPoint.getSslTrust()[0];
            }
            arrayList.add(cMPackageInfo);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IdVersionPair> addPackages(Collection<CMPackageInfo> collection) {
        ArrayList<Future<IdVersionPair>> arrayList = new ArrayList<Future<IdVersionPair>>();
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        for (final CMPackageInfo cMPackageInfo : collection) {
            IdVersionPair idVersionPair = cMPackageInfo.getPackageRef();
            try {
                boolean bl;
                final SessionUtil.ThreadContext threadContext = this._registeredPackageRefs;
                synchronized (threadContext) {
                    bl = this._registeredPackageRefs.contains(idVersionPair);
                    if (!bl) {
                        bl = this._extensionService.getPluginPackageInfo(idVersionPair) != null;
                    }
                }
                if (bl) {
                    hashSet.add(idVersionPair);
                    continue;
                }
                threadContext = SessionUtil.getThreadContext((boolean)true);
                Callable<IdVersionPair> callable = new Callable<IdVersionPair>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public IdVersionPair call() {
                        SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                        try {
                            IdVersionPair idVersionPair;
                            IdVersionPair idVersionPair2 = idVersionPair = CmExtensionManager.this.downloadAndAddPackage(cMPackageInfo);
                            return idVersionPair2;
                        }
                        finally {
                            SessionUtil.setThreadContext(null);
                        }
                    }
                };
                Future<IdVersionPair> future = EXECUTOR.submit(callable);
                arrayList.add(future);
            }
            catch (Exception exception) {
                _logger.error((Object)("Adding Component Manager extension " + idVersionPair + " failed"), (Throwable)exception);
            }
        }
        CmExtensionManager.getAddedPackageRefs(arrayList, hashSet);
        Set<IdVersionPair> set = this._registeredPackageRefs;
        synchronized (set) {
            this._registeredPackageRefs.addAll(hashSet);
        }
        return hashSet;
    }

    private static void getAddedPackageRefs(List<Future<IdVersionPair>> list, Set<IdVersionPair> set) {
        for (Future<IdVersionPair> future : list) {
            try {
                IdVersionPair idVersionPair = future.get();
                if (idVersionPair == null) continue;
                set.add(idVersionPair);
            }
            catch (Exception exception) {
                _logger.error((Object)"Adding Component Manager extension failed", (Throwable)exception);
            }
        }
    }

    private IdVersionPair downloadAndAddPackage(CMPackageInfo cMPackageInfo) {
        File file = this.downloadPackage(cMPackageInfo);
        if (file == null) {
            return null;
        }
        cMPackageInfo.setDirectory(file);
        IdVersionPair idVersionPair = null;
        try {
            Set set = this._extensionService.addPluginPackages(new PluginPackageInfo[]{cMPackageInfo});
            if (set != null && set.size() == 1) {
                idVersionPair = (IdVersionPair)set.iterator().next();
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Adding Component Manager extension " + cMPackageInfo.getPackageRef() + " failed"), (Throwable)exception);
        }
        return idVersionPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private File downloadPackage(CMPackageInfo cMPackageInfo) {
        Object object;
        File file = this.getPackageDir(cMPackageInfo.getPackageRef());
        Object object2 = object = this.getPackageDirLock(file);
        synchronized (object2) {
            boolean bl;
            boolean bl2 = bl = !file.mkdirs();
            if (bl) {
                return file;
            }
            File file2 = null;
            try {
                file2 = File.createTempFile("vmw-pckg", ".zip");
                file2.deleteOnExit();
                try {
                    this.writePackageToFile(cMPackageInfo, file2);
                }
                catch (IOException | GeneralSecurityException exception) {
                    _logger.warn((Object)String.format("Could not download bundle from %s: %s", cMPackageInfo.url, exception.toString()));
                    FileUtil.deleteDir((File)file);
                    File file3 = null;
                    if (file2 != null) {
                        file2.delete();
                    }
                    return file3;
                }
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(file2);
                    ZipUtil.unzip((ZipFile)zipFile, (File)file);
                }
                catch (IOException iOException) {
                    File file4;
                    try {
                        _logger.warn((Object)String.format("Could not unzip bundle downloaded from %s: %s", cMPackageInfo.url, iOException.toString()));
                        FileUtil.deleteDir((File)file);
                        file4 = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            StreamUtil.close((ZipFile)zipFile);
                            throw throwable;
                        }
                        catch (Exception exception) {
                            _logger.error((Object)String.format("Error handling package %s. ", cMPackageInfo.url), (Throwable)exception);
                            FileUtil.deleteDir((File)file);
                            File file5 = null;
                            return file5;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                    StreamUtil.close((ZipFile)zipFile);
                    if (file2 != null) {
                        file2.delete();
                    }
                    return file4;
                }
                StreamUtil.close((ZipFile)zipFile);
            }
            finally {
                if (file2 != null) {
                    file2.delete();
                }
            }
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackageToFile(CMPackageInfo cMPackageInfo, File file) throws IOException, GeneralSecurityException {
        String string = cMPackageInfo.certificate;
        URL uRL = new URL(cMPackageInfo.url);
        String string2 = uRL.getProtocol();
        InputStream inputStream = null;
        if ("https".equals(string2) && !StringUtil.isNullOrEmpty((String)string)) {
            String string3 = CertificateUtil.getThumbprint((String)string);
            SSLBuilder sSLBuilder = new SSLBuilder();
            if (this._sslConfigurationProvider != null) {
                sSLBuilder.sslConfigurationProvider(this._sslConfigurationProvider);
            }
            sSLBuilder.socketReadTimeout(Integer.valueOf(Config.CM_EXTENSION_MANAGER_SOCKET_READ_TIMEOUT.toIntMillis()));
            sSLBuilder.socketConnectionTimeout(Integer.valueOf(Config.CM_EXTENSION_MANAGER_SOCKET_CONNECTION_TIMEOUT.toIntMillis()));
            sSLBuilder.thumbprint(string3);
            HttpClient httpClient = sSLBuilder.buildHttpClientIgnoreErrors();
            inputStream = httpClient.executeMethodResponseAsStream(cMPackageInfo.url, null, null);
        } else {
            Boolean bl = VcExtensionUtil.isHttpDownloadAllowed(this._configurationService);
            if (!bl.booleanValue()) {
                _logger.error((Object)("The plugin package (" + cMPackageInfo.getId() + ") download " + "was blocked because the URL is " + "not secure. To allow http URLs add allowHttp=true to webclient.properties"));
                return;
            }
            inputStream = uRL.openStream();
            inputStream = uRL.openStream();
        }
        try {
            FileUtil.writeFile((InputStream)inputStream, (File)file);
        }
        finally {
            inputStream.close();
        }
    }

    private Object getPackageDirLock(File file) {
        Object object;
        Object object2 = this._lockByPackageDir.get(file);
        if (object2 == null && (object = this._lockByPackageDir.putIfAbsent(file, object2 = new Object())) != null) {
            object2 = object;
        }
        return object2;
    }

    private Object removePackageDirLock(File file) {
        return this._lockByPackageDir.remove(file);
    }

    private File getPackageDir(IdVersionPair idVersionPair) {
        String string = idVersionPair.getId() + "-" + idVersionPair.getVersion();
        File file = new File(Environment.clientAppDataFolder());
        File file2 = new File(new File(file, "cm-service-packages"), PLUGIN_ENDPOINT_TYPE_ID);
        File file3 = new File(file2, string);
        return file3;
    }

    @VisibleForTesting
    static class CMPackageInfo
    extends PluginPackageInfo {
        public String url;
        public String certificate;

        CMPackageInfo() {
        }
    }
}

