/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm.impl;

import com.vmware.vim.binding.cis.cm.ComponentManager;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.cis.cm.fault.InvalidLoginFault;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vise.vim.cm.LoginCallback;
import com.vmware.vise.vim.cm.impl.CmUtil;
import com.vmware.vise.vim.cm.impl.ComponentManagerLocator;
import com.vmware.vise.vim.security.sso.impl.NgcSolutionUser;

public class DefaultLoginCallback
implements LoginCallback {
    private final ComponentManagerLocator _cmLocator;
    private static final String ALREADY_LOGGED_IN_ERROR = "cis.exception.invalidLoginFault.alreadyAuthenticated";

    public DefaultLoginCallback(ComponentManagerLocator componentManagerLocator) {
        this._cmLocator = componentManagerLocator;
    }

    @Override
    public synchronized void login(ComponentManager componentManager) throws ComponentManagerFault {
        NgcSolutionUser ngcSolutionUser = NgcSolutionUser.instance();
        SignInfoImpl signInfoImpl = new SignInfoImpl(ngcSolutionUser.getPrivateKey(), ngcSolutionUser.getLoggedInToken());
        this.login(componentManager, (SignInfo)signInfoImpl);
    }

    protected synchronized void login(ComponentManager componentManager, SignInfo signInfo) throws ComponentManagerFault {
        RequestContextImpl requestContextImpl = new RequestContextImpl();
        requestContextImpl.setSignInfo(signInfo);
        ((Stub)componentManager)._setRequestContext((RequestContext)requestContextImpl);
        try {
            componentManager.loginByToken();
        }
        catch (InvalidLoginFault invalidLoginFault) {
            if (invalidLoginFault.getErrorMessage() != null && ALREADY_LOGGED_IN_ERROR.equals(invalidLoginFault.getErrorMessage().getKey())) {
                return;
            }
            CmUtil.handleException((Exception)((Object)invalidLoginFault), this._cmLocator.getServiceUri());
        }
        catch (Exception exception) {
            CmUtil.handleException(exception, this._cmLocator.getServiceUri());
        }
    }
}

