/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.connections;

import com.vmware.identity.cdc.CdcDCEntry;
import com.vmware.identity.cdc.CdcFactory;
import com.vmware.identity.cdc.CdcSession;
import com.vmware.identity.cdc.CdcState;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vise.vim.cdc.CdcData;
import com.vmware.vise.vim.cdc.CdcDataProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiteAffinityServerEndpointProvider
implements ServerEndpointProvider,
CdcDataProvider {
    private static final String DISABLED_MSG = "Site affinity is disabled, using default address to connect to PSC: ";
    private static final String ENABLED_MSG = "Site affinity DC name: ";
    private static final long EXECUTION_TIME_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(500L);
    private final URI _serverUri;
    private static final int FLAGS = 0;
    private Boolean _isEnabled;
    private static boolean _isMisconfigured = false;
    private static final Log _logger = LogFactory.getLog(SiteAffinityServerEndpointProvider.class);
    private static volatile String _previousAffinitizedDcHost = null;

    public SiteAffinityServerEndpointProvider(URI uRI) {
        this._serverUri = uRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getServerEndpoint() {
        if (_isMisconfigured) {
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)("CDC is misconfigured. Returning the original URI unchanged: " + this._serverUri));
            }
            return this._serverUri;
        }
        _logger.debug((Object)"Running getServerEndpoint()");
        long l = System.nanoTime();
        long l2 = -1L;
        URI uRI = null;
        try {
            URI uRI2 = this.getServiceLocationInternal();
            l2 = System.nanoTime();
            URI uRI3 = uRI = uRI2;
            return uRI3;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError linkageError) {
            l2 = System.nanoTime();
            if (!_isMisconfigured) {
                _logger.warn((Object)("CDC misconfigured due to " + linkageError.toString() + ". Will use URI " + this._serverUri));
                _isMisconfigured = true;
            }
            URI uRI4 = uRI = this._serverUri;
            return uRI4;
        }
        finally {
            long l3 = l2 - l;
            if (l3 > EXECUTION_TIME_THRESHOLD_NANOS) {
                _logger.warn((Object)("getServerEndpoint() took too long: " + l3 + " ms"));
            } else if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("getServerEndpoint() done: " + uRI));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URI getServiceLocationInternal() {
        try (CdcSession cdcSession = CdcFactory.createCdcSessionViaIPC();){
            boolean bl;
            boolean bl2 = bl = cdcSession.getCdcState() == CdcState.CDC_STATE_DISABLED;
            if (bl) {
                if (this._isEnabled == null || Boolean.TRUE.equals(this._isEnabled)) {
                    _logger.info((Object)(DISABLED_MSG + this._serverUri));
                    this._isEnabled = Boolean.FALSE;
                }
                URI uRI2 = this._serverUri;
                return uRI2;
            }
            URI uRI = this.getDomainController(cdcSession);
            return uRI;
        }
        catch (RuntimeException runtimeException) {
            _logger.error((Object)String.format("Failed to create affinitized URL %s", runtimeException.toString()), (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            _logger.warn((Object)String.format("Failed to create affinitized URL %s", exception.toString()), (Throwable)exception);
            return this._serverUri;
        }
    }

    private URI getDomainController(CdcSession cdcSession) {
        try {
            CdcDCEntry cdcDCEntry = cdcSession.getAffinitizedDC(null, 0);
            if (this._isEnabled == null || Boolean.FALSE.equals(this._isEnabled)) {
                _logger.info((Object)(ENABLED_MSG + cdcDCEntry.dcName));
                this._isEnabled = Boolean.TRUE;
            }
            URI uRI = new URI(this._serverUri.getScheme(), this._serverUri.getUserInfo(), cdcDCEntry.dcName, this._serverUri.getPort(), this._serverUri.getPath(), this._serverUri.getQuery(), this._serverUri.getFragment());
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Failed to create affinitized URL", uRISyntaxException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @CheckForNull
    public CdcData getCdcData() {
        if (_isMisconfigured) {
            _logger.trace((Object)"CDC is misconfigured. Returning null.");
            return null;
        }
        try (CdcSession cdcSession = CdcFactory.createCdcSessionViaIPC();){
            boolean bl;
            CdcDCEntry cdcDCEntry;
            boolean bl2;
            CdcState cdcState = cdcSession.getCdcState();
            boolean bl3 = bl2 = cdcState == CdcState.CDC_STATE_DISABLED;
            if (bl2) {
                _logger.trace((Object)"Site affinity is disabled");
            }
            if ((cdcDCEntry = cdcSession.getAffinitizedDC(null, 0)) == null) {
                throw new IllegalStateException("CDC returned a null domain controller");
            }
            String string = cdcDCEntry.dcName;
            String string2 = _previousAffinitizedDcHost;
            boolean bl4 = string != null ? string.equals(string2) : (bl = string2 == null);
            if (!bl) {
                _logger.info((Object)("Affinitized CDC host changed from '" + string2 + "' to '" + string + "'"));
                _previousAffinitizedDcHost = string;
            } else if (_logger.isTraceEnabled()) {
                _logger.trace((Object)("Determined affinitized PSC host: " + string));
            }
            CdcData cdcData = new CdcData(cdcState, string);
            return cdcData;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError linkageError) {
            _isMisconfigured = true;
            _logger.warn((Object)"CDC is misconfigured. Will not use CDC.", (Throwable)linkageError);
            return null;
        }
    }
}

