/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.util.VmodlUtil;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VimObjectReferenceServiceImpl
implements VimObjectReferenceService {
    private static final Log _logger = LogFactory.getLog(VimObjectReferenceServiceImpl.class);
    private final ObjectReferenceService _dsObjRefSvc;

    public VimObjectReferenceServiceImpl(ObjectReferenceService objectReferenceService) {
        this.validateUsability(objectReferenceService);
        this._dsObjRefSvc = objectReferenceService;
    }

    public String getResourceObjectType(Object object) {
        String string = this._dsObjRefSvc.getResourceObjectType(object);
        return string;
    }

    public String getServerGuid(Object object) {
        String string = this._dsObjRefSvc.getServerGuid(object);
        return string;
    }

    public String getUid(Object object) {
        String string = this._dsObjRefSvc.getUid(object);
        return string;
    }

    public Object getReference(String string) {
        Object object = this._dsObjRefSvc.getReference(string);
        return object;
    }

    @Override
    public Object getReference(String string, String string2, String string3) {
        if (VmodlUtil.getClassFromTypeName((String)string) != null) {
            String string4 = VmodlUtil.morefToString((String)string, (String)string2, (String)string3);
            return this.getReference(string4);
        }
        String string5 = string2;
        if (!StringUtils.isEmpty((String)string3)) {
            string5 = string5 + ":" + string3;
        }
        return DefaultUriSchemeUtil.createUri((String)string, (String)string5);
    }

    @Override
    public String getValue(Object object) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        if (object instanceof ManagedObjectReference) {
            return ((ManagedObjectReference)object).getValue();
        }
        return this.getUid(object);
    }

    private void validateUsability(ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService});
        if (VimObjectReferenceServiceImpl.class.equals(objectReferenceService.getClass())) {
            String string = "ObjectReferenceService instance passed into this class is of VimReferenceServiceImpl type therefore will not be usable.";
            assert (false) : string;
            _logger.warn((Object)string);
        }
    }

    public String getUid(Object object, boolean bl) {
        return this.getUid(object);
    }

    public Object getReference(String string, boolean bl) {
        return this.getReference(string);
    }
}

