/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.persistence;

import com.vmware.vise.extensionfw.ExtensionPersistenceProvider;
import com.vmware.vise.extensionfw.PluginPackageStateInfo;
import com.vmware.vise.store.GroupPermission;
import com.vmware.vise.store.OperationResult;
import com.vmware.vise.store.Permission;
import com.vmware.vise.store.PersistenceService;
import com.vmware.vise.store.UserData;
import com.vmware.vise.store.UserDataMetadata;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExtensionPersistenceProviderImpl
implements ExtensionPersistenceProvider {
    private final PersistenceService _persistenceService;
    private static final String PACKAGE_STATES = "client.package.states";
    private static final String SESSION_PACKAGES_STATES = "pluginPackageStates";

    public ExtensionPersistenceProviderImpl(PersistenceService persistenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{persistenceService});
        this._persistenceService = persistenceService;
    }

    public PluginPackageStateInfo[] getPackageStates() throws Exception {
        PluginPackageStateInfo[] pluginPackageStateInfoArray = (PluginPackageStateInfo[])SessionUtil.getData((String)SESSION_PACKAGES_STATES);
        if (pluginPackageStateInfoArray != null) {
            return pluginPackageStateInfoArray;
        }
        String string = this.getQueryId();
        OperationResult operationResult = this._persistenceService.getUserData(string, null, null);
        if (operationResult != null && operationResult.result instanceof UserData) {
            UserData userData = (UserData)operationResult.result;
            pluginPackageStateInfoArray = this.deserializePackageInfo((String)userData.value);
        }
        if (pluginPackageStateInfoArray == null) {
            pluginPackageStateInfoArray = new PluginPackageStateInfo[]{};
        }
        SessionUtil.setData((String)SESSION_PACKAGES_STATES, (Object)pluginPackageStateInfoArray, (boolean)false);
        return pluginPackageStateInfoArray;
    }

    public void setPackageStates(PluginPackageStateInfo[] userData) throws Exception {
        if (userData == null) {
            return;
        }
        PluginPackageStateInfo[] pluginPackageStateInfoArray = this.getPackageStates();
        ArrayList<Object> arrayList = null;
        if (pluginPackageStateInfoArray != null) {
            arrayList = new ArrayList<PluginPackageStateInfo>(Arrays.asList(pluginPackageStateInfoArray));
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        for (PluginPackageStateInfo pluginPackageStateInfo : userData) {
            this.processPackage(pluginPackageStateInfo, arrayList);
        }
        UserData userData2 = new UserData();
        userData2.metadata = new UserDataMetadata();
        userData2.metadata.uid = this.getQueryId();
        GroupPermission groupPermission = new GroupPermission();
        userData2.sharedPermissions = new Permission[]{groupPermission};
        PluginPackageStateInfo[] pluginPackageStateInfoArray2 = arrayList.toArray(new PluginPackageStateInfo[0]);
        userData2.value = this.serializePackageInfo(pluginPackageStateInfoArray2);
        SessionUtil.setData((String)SESSION_PACKAGES_STATES, (Object)pluginPackageStateInfoArray2);
        this._persistenceService.setUserData(userData2, false, null);
    }

    private void processPackage(PluginPackageStateInfo pluginPackageStateInfo, List<PluginPackageStateInfo> list) {
        boolean bl = false;
        for (PluginPackageStateInfo pluginPackageStateInfo2 : list) {
            if (!pluginPackageStateInfo.getPackageRef().equals((Object)pluginPackageStateInfo2.getPackageRef())) continue;
            bl = true;
            pluginPackageStateInfo2.setState(pluginPackageStateInfo.getState());
            break;
        }
        if (!bl) {
            list.add(pluginPackageStateInfo);
        }
    }

    private String getQueryId() {
        return PACKAGE_STATES;
    }

    private String serializePackageInfo(PluginPackageStateInfo[] pluginPackageStateInfoArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PluginPackageStateInfo pluginPackageStateInfo : pluginPackageStateInfoArray) {
            stringBuilder.append(pluginPackageStateInfo.getPackageRef().getId() + ":" + pluginPackageStateInfo.getPackageRef().getVersion() + ":" + pluginPackageStateInfo.getState());
            stringBuilder.append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private PluginPackageStateInfo[] deserializePackageInfo(String string) {
        String[] stringArray = string.split(",");
        ArrayList<PluginPackageStateInfo> arrayList = new ArrayList<PluginPackageStateInfo>();
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split(":");
            IdVersionPair idVersionPair = new IdVersionPair(stringArray2[0], stringArray2[1]);
            PluginPackageStateInfo pluginPackageStateInfo = new PluginPackageStateInfo();
            pluginPackageStateInfo.setPackageRef(idVersionPair);
            pluginPackageStateInfo.setState(Boolean.parseBoolean(stringArray2[2]));
            arrayList.add(pluginPackageStateInfo);
        }
        return arrayList.toArray(new PluginPackageStateInfo[0]);
    }
}

