/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.internal;

import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.Timeout;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config {
    private static final Log _logger = LogFactory.getLog(Config.class);
    private static final String CONFIG_FILE_NAME = "vim-services.properties";
    public static final int VMOMI_HTTP_CONNECTION_POOL_SIZE_SSO;
    public static final int VMOMI_HTTP_CONNECTION_POOL_SIZE_PER_ROUTE_SSO;
    public static final int VMOMI_HTTP_SOCKET_TIMEOUT_SSO;
    public static final int VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_SSO;
    public static final int VMOMI_HTTP_CONNECTION_POOL_SIZE_CM;
    public static final int VMOMI_HTTP_SOCKET_TIMEOUT_CM;
    public static final int VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_CM;
    public static final int VMOMI_HTTP_CONNECTION_POOL_SIZE_LS;
    public static final int VMOMI_HTTP_SOCKET_TIMEOUT_LS;
    public static final int VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_LS;
    public static final int VMOMI_HTTP_CONNECTION_POOL_SIZE_SCA;
    public static final int VMOMI_HTTP_SOCKET_TIMEOUT_SCA;
    public static final int VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_SCA;
    public static final long VAPI_OPERATION_INVOCATION_THRESHOLD_NANOS;
    public static final int CM_CATALOG_MANAGER_SOCKET_TIMEOUT;
    public static final int CM_CATALOG_MANAGER_SOCKET_CONNECTION_TIMEOUT;
    public static final int CM_CATALOG_MANAGER_CONNECTION_REQUEST_TIMEOUT;
    public static final long CM_CATALOG_MANAGER_BUNDLE_DOWNLOAD_RETRY_TIMEOUT;
    public static final long CM_CATALOG_MANAGER_BUNDLE_DOWNLOAD_RETRY_SLICE;
    public static final long CM_CATALOG_MANAGER_SYNC_TIMEOUT;
    public static final Timeout CM_EXTENSION_MANAGER_SOCKET_CONNECTION_TIMEOUT;
    public static final Timeout CM_EXTENSION_MANAGER_SOCKET_READ_TIMEOUT;
    public static final boolean CM_USE_OP_ID_AWARE_CLIENT;
    public static final Timeout LS_EXTENSION_MANAGER_SOCKET_CONNECTION_TIMEOUT;
    public static final Timeout LS_EXTENSION_MANAGER_SOCKET_READ_TIMEOUT;
    public static final long SSO_CACHE_REFRESH_INTERVAL_IN_NANOS;

    private static void logWarningIfSocketTimeoutValueExceedsInteger(String string, long l) {
        if (l > Integer.MAX_VALUE) {
            _logger.warn((Object)("Property '" + string + "' has a value of " + l + " which exceeds the maximum for the int type. " + "The value will be truncated to " + Integer.MAX_VALUE + " when used to set the corresponding socket timeout."));
        }
    }

    static {
        ClassLoader classLoader = Config.class.getClassLoader();
        Properties properties = PropertyUtil.loadProperties((ClassLoader)classLoader, (String)CONFIG_FILE_NAME);
        if (properties == null) {
            _logger.warn((Object)"Properties file not found. Will use System properties or, if they are not specified or not valid, will use defaults.");
        }
        VMOMI_HTTP_CONNECTION_POOL_SIZE_SSO = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.connection.pool.size.sso", (int)2000);
        VMOMI_HTTP_CONNECTION_POOL_SIZE_PER_ROUTE_SSO = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.connection.pool.size.per.route.sso", (int)500);
        VMOMI_HTTP_SOCKET_TIMEOUT_SSO = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.socket.timeout.sso", (int)300000);
        VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_SSO = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.socket.connection.timeout.sso", (int)15000);
        VMOMI_HTTP_CONNECTION_POOL_SIZE_CM = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.connection.pool.size.cm", (int)500);
        VMOMI_HTTP_SOCKET_TIMEOUT_CM = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.socket.timeout.cm", (int)300000);
        VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_CM = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.socket.connection.timeout.cm", (int)15000);
        VMOMI_HTTP_CONNECTION_POOL_SIZE_LS = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.connection.pool.size.ls", (int)500);
        VMOMI_HTTP_SOCKET_TIMEOUT_LS = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.socket.timeout.ls", (int)300000);
        VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_LS = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.socket.connection.timeout.ls", (int)15000);
        VMOMI_HTTP_CONNECTION_POOL_SIZE_SCA = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.connection.pool.size.sca", (int)500);
        VMOMI_HTTP_SOCKET_TIMEOUT_SCA = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.socket.timeout.sca", (int)300000);
        VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_SCA = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.vmomi.http.socket.connection.timeout.sca", (int)15000);
        long l = PropertyUtil.getLongProperty((Properties)properties, (String)"vim.services.vmomi.http.socket.connection.timeout.sca", (long)TimeUnit.MILLISECONDS.toNanos(10000L));
        VAPI_OPERATION_INVOCATION_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(l);
        CM_CATALOG_MANAGER_SOCKET_TIMEOUT = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.cm.catalog.manager.socket.timeout", (int)-1);
        CM_CATALOG_MANAGER_SOCKET_CONNECTION_TIMEOUT = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.cm.catalog.manager.socket.connection.timeout", (int)-1);
        CM_CATALOG_MANAGER_CONNECTION_REQUEST_TIMEOUT = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.services.cm.catalog.manager.connection.request.timeout", (int)-1);
        CM_CATALOG_MANAGER_BUNDLE_DOWNLOAD_RETRY_TIMEOUT = PropertyUtil.getLongProperty((Properties)properties, (String)"vim.services.cm.catalog.manager.bundle.download.retry.timeout", (long)300000L);
        CM_CATALOG_MANAGER_BUNDLE_DOWNLOAD_RETRY_SLICE = PropertyUtil.getLongProperty((Properties)properties, (String)"vim.services.cm.catalog.manager.bundle.download.retry.slice", (long)30000L);
        CM_CATALOG_MANAGER_SYNC_TIMEOUT = PropertyUtil.getLongProperty((Properties)properties, (String)"vim.services.cm.catalog.manager.sync.timeout", (long)30000L);
        String string = "vim.services.cm.extension.manager.socket.connection.timeout";
        long l2 = PropertyUtil.getLongProperty((Properties)properties, (String)string, (long)Timeout.DEFAULT.toMillis());
        Config.logWarningIfSocketTimeoutValueExceedsInteger(string, l2);
        CM_EXTENSION_MANAGER_SOCKET_CONNECTION_TIMEOUT = Timeout.valueOf((long)l2);
        string = "vim.services.cm.extension.manager.socket.timeout";
        l2 = PropertyUtil.getLongProperty((Properties)properties, (String)string, (long)Timeout.DEFAULT.toMillis());
        Config.logWarningIfSocketTimeoutValueExceedsInteger(string, l2);
        CM_EXTENSION_MANAGER_SOCKET_READ_TIMEOUT = Timeout.valueOf((long)l2);
        CM_USE_OP_ID_AWARE_CLIENT = PropertyUtil.getBooleanProperty((Properties)properties, (String)"vim.services.cm.use.OpIdAwareClient", (boolean)true);
        string = "vim.services.ls.extension.manager.socket.connection.timeout";
        l2 = PropertyUtil.getLongProperty((Properties)properties, (String)string, (long)Timeout.DEFAULT.toMillis());
        Config.logWarningIfSocketTimeoutValueExceedsInteger(string, l2);
        LS_EXTENSION_MANAGER_SOCKET_CONNECTION_TIMEOUT = Timeout.valueOf((long)l2);
        string = "vim.services.ls.extension.manager.socket.timeout";
        l2 = PropertyUtil.getLongProperty((Properties)properties, (String)string, (long)Timeout.DEFAULT.toMillis());
        Config.logWarningIfSocketTimeoutValueExceedsInteger(string, l2);
        LS_EXTENSION_MANAGER_SOCKET_READ_TIMEOUT = Timeout.valueOf((long)l2);
        SSO_CACHE_REFRESH_INTERVAL_IN_NANOS = TimeUnit.MILLISECONDS.toNanos(PropertyUtil.getLongProperty((Properties)properties, (String)"vim.services.sso.cache.refresh.interval", (long)120000L));
    }
}

