/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.lookup.impl;

import com.vmware.af.VmAfClient;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.lookup.impl.LookupServiceSource;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AfdLSSource
extends LookupServiceSource {
    private static final Log _logger = LogFactory.getLog(AfdLSSource.class);
    private static final String AFD_DISABLED = "afd.disabled";
    private URI _serviceUri;

    public AfdLSSource(KeystoreService keystoreService) {
        super(keystoreService);
    }

    @Override
    public synchronized URI getServiceUri() {
        if (this._serviceUri == null) {
            this._serviceUri = this.getLSUrl();
        }
        return this._serviceUri;
    }

    public static LookupServiceSource tryCreate(ConfigurationService configurationService, KeystoreService keystoreService) {
        AfdLSSource afdLSSource = null;
        boolean bl = Boolean.parseBoolean(configurationService.getProperty(AFD_DISABLED));
        if (!bl) {
            afdLSSource = new AfdLSSource(keystoreService);
        }
        return afdLSSource;
    }

    private URI getLSUrl() {
        String string = null;
        try {
            String string2 = "localhost";
            _logger.info((Object)("Creating vm afd client at " + string2));
            VmAfClient vmAfClient = new VmAfClient(string2);
            string = vmAfClient.getLSLocation();
            _logger.info((Object)("LS location from afd: " + string));
            URI uRI = AfdLSSource.toServiceUri(string.trim());
            return uRI;
        }
        catch (Error error) {
            _logger.error((Object)"Error when talking to afd client", (Throwable)error);
            return null;
        }
    }
}

