/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.util.ArrayList;
import java.util.List;

public class AuthorizationUtil {
    private static final String ROLE_LABEL_KEY = "role.%s.label";
    private static final String PRIVILEGE_LABEL_KEY = "privilege.%s.label";
    private static final String PRIVILEGE_SUMMARY_KEY = "privilege.%s.summary";
    public static final String GRANTED_PRIVILEGES = "grantedPrivileges";

    public static boolean isPrivilegeGranted(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return true;
        }
        if (stringArray2 == null) {
            return false;
        }
        for (String string : stringArray) {
            Boolean bl = false;
            for (String string2 : stringArray2) {
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean isOperationAllowed(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return true;
        }
        if (stringArray2 == null) {
            return false;
        }
        for (String string : stringArray) {
            Boolean bl = true;
            for (String string2 : stringArray2) {
                if (!string.equals(string2)) continue;
                bl = false;
                break;
            }
            if (bl.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static void addPrivilegeLocalizationKeys(String string, List<String> list) {
        String string2 = String.format(PRIVILEGE_LABEL_KEY, string);
        String string3 = String.format(PRIVILEGE_SUMMARY_KEY, string);
        list.add(string2);
        list.add(string3);
    }

    public static void addGroupLocalizationKeys(String string, ArrayList<String> arrayList) {
        if (string.contains(".")) {
            String[] stringArray = string.split("\\.");
            String string2 = "";
            for (String string3 : stringArray) {
                if (!"".equals(string2)) {
                    string2 = string2 + ".";
                }
                string2 = string2 + string3;
                AuthorizationUtil.addPrivilegeLocalizationKeys(string2, arrayList);
            }
        } else {
            AuthorizationUtil.addPrivilegeLocalizationKeys(string, arrayList);
        }
    }

    public static String getRoleLocalizedName(String string) {
        String string2;
        if (StringUtil.isNullOrEmpty((String)string)) {
            return string;
        }
        String string3 = String.format(ROLE_LABEL_KEY, string);
        return string3.equals(string2 = LocalizationUtil.getLocalizedMessage((String)string3, null)) ? string : string2;
    }
}

