/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso;

import com.vmware.vise.util.common.Environment;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NgcCmServiceSpecConfig {
    private static final Log _logger = LogFactory.getLog(NgcCmServiceSpecConfig.class);
    private static final String FILE_SEPARATOR = Environment.fileSeparator();
    private static final String NGC_SERVICE_FILENAME = "service-spec.prop";
    private static final String FIRST_BOOT_DIR = "firstboot";
    private static final String NGC_SERVICE_SPEC_FILE = Environment.clientAppDataFolder() + FILE_SEPARATOR + "firstboot" + FILE_SEPARATOR + "service-spec.prop";
    public static final String NGC_URL = "endpoint0.url";
    private final Properties _properties = new Properties();

    public NgcCmServiceSpecConfig() {
        this.load();
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public String getProperty(String string, String string2) {
        return this._properties.getProperty(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(NGC_SERVICE_SPEC_FILE);
            this._properties.load(fileInputStream);
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to load service spec properties file - " + exception.getMessage()));
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

