/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.identity.cdc.CdcDCEntry;
import com.vmware.identity.cdc.CdcFactory;
import com.vmware.identity.cdc.CdcSession;
import com.vmware.identity.cdc.CdcState;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import com.vmware.vise.vim.internal.Config;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vise.vim.security.sso.impl.NgcSolutionUser;
import com.vmware.vise.vim.security.sso.impl.SsoAdminServiceImpl;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SsoUtil {
    private static final Pattern NETBIOS_PATTERN = Pattern.compile("(.*)\\\\(.+)");
    private static final Pattern UPN_PATTERN = Pattern.compile("(.+)@(.*)");
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final AtomicReference<SharedHttpConfigPool> _legacyHttpConfigPoolRef = new AtomicReference();
    private static volatile String _previousAffinitizedDcHost = null;

    @VisibleForTesting
    static void setHttpConfigPool(@Nullable SharedHttpConfigPool sharedHttpConfigPool) {
        _legacyHttpConfigPoolRef.set(sharedHttpConfigPool);
    }

    @Nonnull
    public static SharedHttpConfigPool getLegacyHttpConfigPool() {
        SharedHttpConfigPool sharedHttpConfigPool;
        boolean bl;
        do {
            if ((sharedHttpConfigPool = _legacyHttpConfigPoolRef.get()) == null) continue;
            return sharedHttpConfigPool;
        } while (!(bl = _legacyHttpConfigPoolRef.compareAndSet(null, sharedHttpConfigPool = SharedHttpConfigPool.builder().maxConnections(Config.VMOMI_HTTP_CONNECTION_POOL_SIZE_SSO).timeoutInMillis(Config.VMOMI_HTTP_SOCKET_TIMEOUT_SSO).connectionTimeoutInMillis(Config.VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_SSO).build())));
        return sharedHttpConfigPool;
    }

    public static TokenSpec buildTokenSpec(long l, TokenSpec.DelegationSpec delegationSpec, boolean bl) {
        TokenSpec.Builder builder = new TokenSpec.Builder(l);
        if (delegationSpec != null) {
            builder = builder.delegationSpec(delegationSpec);
        }
        builder = builder.renewable(bl);
        return builder.createTokenSpec();
    }

    public static String getUser() {
        SamlToken samlToken = AuthSessionUtil.getSsoToken();
        return SsoUtil.getUser(samlToken);
    }

    public static String getUser(SamlToken samlToken) {
        PrincipalId principalId = samlToken.getSubject();
        return SsoUtil.toString(principalId);
    }

    public static Set<String> getGroups() {
        SamlToken samlToken = AuthSessionUtil.getSsoToken();
        return SsoUtil.getGroups(samlToken);
    }

    public static Set<String> getGroups(SamlToken samlToken) {
        HashSet<String> hashSet = new HashSet<String>();
        List list = samlToken.getGroupList();
        for (PrincipalId principalId : list) {
            String string = SsoUtil.toString(principalId);
            hashSet.add(string);
        }
        return hashSet;
    }

    private static String toString(PrincipalId principalId) {
        return StringUtil.isNullOrEmpty((String)principalId.getDomain()) ? principalId.getName() : principalId.getDomain() + "\\" + principalId.getName();
    }

    public static String getUserName(String string) {
        Matcher matcher = UPN_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return string2;
        }
        matcher = NETBIOS_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string3 = matcher.group(2);
            return string3;
        }
        return string;
    }

    public static String getDomainName(String string) {
        Matcher matcher = UPN_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(2);
            return string2;
        }
        matcher = NETBIOS_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string3 = matcher.group(1);
            return string3;
        }
        return "";
    }

    public static SamlToken getDelegatedToken(SsoService ssoService, SamlToken samlToken, String string, boolean bl) throws SsoServiceException {
        long l = samlToken.getExpirationTime().getTime() - samlToken.getStartTime().getTime();
        TokenSpec.Builder builder = new TokenSpec.Builder(l - 1000L);
        builder.delegationSpec(new TokenSpec.DelegationSpec(false, string));
        builder.renewable(bl);
        TokenSpec tokenSpec = builder.createTokenSpec();
        SamlToken samlToken2 = ssoService.acquireTokenByToken(samlToken, tokenSpec);
        return samlToken2;
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoService ssoService) throws SsoServiceException {
        return SsoUtil.getAdminService(ssoService, (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool());
    }

    public static SsoAdminService getAdminService(SsoService ssoService, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws SsoServiceException {
        try {
            return SsoUtil.getAdminService(ssoService.getServerInfo(), ssoService, (SamlToken)null, httpConfigurationProvider);
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoServerInfo ssoServerInfo, SsoService ssoService, SamlToken samlToken) throws SsoServiceException {
        return SsoUtil.getAdminService(ssoServerInfo, ssoService, samlToken, (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool());
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoServerInfo ssoServerInfo, SsoService ssoService, SamlToken samlToken, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws SsoServiceException {
        try {
            SsoAdminServiceImpl ssoAdminServiceImpl = new SsoAdminServiceImpl(ssoServerInfo, ssoService, samlToken, httpConfigurationProvider);
            return ssoAdminServiceImpl;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoServerInfo ssoServerInfo, SsoService ssoService, SsoSolutionUser ssoSolutionUser) throws SsoServiceException {
        return SsoUtil.getAdminService(ssoServerInfo, ssoService, ssoSolutionUser, (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool());
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoServerInfo ssoServerInfo, SsoService ssoService, SsoSolutionUser ssoSolutionUser, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws SsoServiceException {
        try {
            SsoAdminServiceImpl ssoAdminServiceImpl = new SsoAdminServiceImpl(ssoServerInfo, ssoService, ssoSolutionUser, httpConfigurationProvider);
            return ssoAdminServiceImpl;
        }
        catch (Exception exception) {
            throw new SsoServiceException("SSO admin service failure", exception);
        }
    }

    public static SsoSolutionUser getSolutionUser() {
        return NgcSolutionUser.instance();
    }

    @Nonnull
    public static CdcData getAffinitizedCdcData() {
        try (CdcSession cdcSession = CdcFactory.createCdcSessionViaIPC();){
            boolean bl;
            CdcDCEntry cdcDCEntry;
            boolean bl2;
            CdcState cdcState = cdcSession.getCdcState();
            boolean bl3 = bl2 = cdcState == CdcState.CDC_STATE_DISABLED;
            if (bl2) {
                _logger.trace((Object)"Site affinity is disabled");
            }
            if ((cdcDCEntry = cdcSession.getAffinitizedDC(null, 0)) == null) {
                throw new IllegalStateException("CDC returned a null domain controller");
            }
            String string = cdcDCEntry.dcName;
            String string2 = _previousAffinitizedDcHost;
            boolean bl4 = string != null ? string.equals(string2) : (bl = string2 == null);
            if (!bl) {
                _logger.info((Object)("Affinitized CDC host changed from '" + string2 + "' to '" + string + "'"));
                _previousAffinitizedDcHost = string;
            } else if (_logger.isTraceEnabled()) {
                _logger.trace((Object)("Determined affinitized PSC host: " + string));
            }
            CdcData cdcData = new CdcData(cdcState, string);
            return cdcData;
        }
    }

    @CheckForNull
    public static CdcData getAffinitizedCdcDataNoException() {
        try {
            return SsoUtil.getAffinitizedCdcData();
        }
        catch (RuntimeException runtimeException) {
            _logger.error((Object)"Failed to determine the affinitized PSC host", (Throwable)runtimeException);
            return null;
        }
    }

    public static class CdcData {
        private final CdcState _cdcState;
        private final String _affinitizedDcHostName;

        public CdcData(CdcState cdcState, String string) {
            this._cdcState = cdcState;
            this._affinitizedDcHostName = string;
        }

        public CdcState getCdcState() {
            return this._cdcState;
        }

        public String getAffinitizedDcHostName() {
            return this._affinitizedDcHostName;
        }
    }
}

