/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.vim.binding.sso.SessionManager;
import com.vmware.vim.binding.sso.admin.ComputerManagementService;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.IdentitySourceManagementService;
import com.vmware.vim.binding.sso.admin.LockoutPolicyService;
import com.vmware.vim.binding.sso.admin.PasswordPolicyService;
import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.binding.sso.admin.PrincipalManagementService;
import com.vmware.vim.binding.sso.admin.RoleManagementService;
import com.vmware.vim.binding.sso.admin.ServiceContent;
import com.vmware.vim.binding.sso.admin.SystemManagementService;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.client.ClientAuthenticator;
import com.vmware.vise.util.concurrent.client.ClientMonitor;
import com.vmware.vise.util.concurrent.client.ClientMonitorImpl;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vise.vim.security.sso.impl.SsoUtilInternal;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoAdminServiceImpl
implements SsoAdminService {
    private static final Log _logger = LogFactory.getLog(SsoAdminServiceImpl.class);
    private static final ClientAuthenticator<Client> NON_AUTHENTICATING_CLIENT_MONITOR = new NonAuthenticatingAuthenticator();
    private final ClientMonitor<Client> _clientMonitor;
    @Nonnull
    private final HttpConfigurationProvider _httpConfigProvider;

    @Deprecated
    public SsoAdminServiceImpl(SsoServerInfo ssoServerInfo, SsoService ssoService, SamlToken samlToken) throws Exception {
        this(ssoServerInfo, ssoService, samlToken, (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool());
    }

    public SsoAdminServiceImpl(SsoServerInfo ssoServerInfo, SsoService ssoService, SamlToken samlToken, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws Exception {
        Validate.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null");
        HttpSession httpSession = SessionUtil.getHttpSession();
        ClientAuthenticator<Client> clientAuthenticator = SsoAdminServiceImpl.getAuthenticator(ssoServerInfo, ssoService, samlToken, httpSession);
        this._httpConfigProvider = httpConfigurationProvider;
        this._clientMonitor = this.getClientMonitor(ssoServerInfo, clientAuthenticator);
    }

    @Deprecated
    public SsoAdminServiceImpl(SsoServerInfo ssoServerInfo, SsoService ssoService, SsoSolutionUser ssoSolutionUser) throws Exception {
        this(ssoServerInfo, ssoService, ssoSolutionUser, (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool());
    }

    public SsoAdminServiceImpl(SsoServerInfo ssoServerInfo, SsoService ssoService, SsoSolutionUser ssoSolutionUser, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws Exception {
        Validate.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null");
        ClientAuthenticator<Client> clientAuthenticator = SsoAdminServiceImpl.getAuthenticator(ssoServerInfo, ssoSolutionUser);
        this._httpConfigProvider = httpConfigurationProvider;
        this._clientMonitor = this.getClientMonitor(ssoServerInfo, clientAuthenticator);
    }

    private ClientMonitor<Client> getClientMonitor(SsoServerInfo ssoServerInfo, ClientAuthenticator<Client> clientAuthenticator) throws Exception {
        if (NON_AUTHENTICATING_CLIENT_MONITOR == clientAuthenticator) {
            RequestRetryCallback requestRetryCallback = null;
            Client client = SsoUtilInternal.createSsoAdminClient(ssoServerInfo, requestRetryCallback, this._httpConfigProvider);
            ClientMonitorImpl clientMonitorImpl = new ClientMonitorImpl((Object)client, clientAuthenticator);
            return clientMonitorImpl;
        }
        RequestRetryCallbackImpl requestRetryCallbackImpl = new RequestRetryCallbackImpl();
        Client client = SsoUtilInternal.createSsoAdminClient(ssoServerInfo, (RequestRetryCallback)requestRetryCallbackImpl, this._httpConfigProvider);
        ClientMonitorImpl clientMonitorImpl = new ClientMonitorImpl((Object)client, clientAuthenticator);
        requestRetryCallbackImpl._clientMonitor = (ClientMonitor)clientMonitorImpl;
        clientMonitorImpl.authenticate();
        return clientMonitorImpl;
    }

    private static void processLogin(Client client, SsoServerInfo ssoServerInfo, SamlToken samlToken, PrivateKey privateKey) throws URISyntaxException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, ServiceFault {
        ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
        ManagedObjectReference managedObjectReference = serviceContent.getSessionManager();
        SessionManager sessionManager = (SessionManager)VmomiClientHelper.createStub((Client)client, SessionManager.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
        RequestContextImpl requestContextImpl = new RequestContextImpl();
        requestContextImpl.setSignInfo((SignInfo)new SignInfoImpl(privateKey, samlToken));
        ((Stub)sessionManager)._setRequestContext((RequestContext)requestContextImpl);
        sessionManager.login();
    }

    @Override
    public ConfigurationManagementService getConfigurationManagementService() throws SsoServiceException {
        Client client = null;
        try {
            ConfigurationManagementService configurationManagementService;
            client = (Client)this._clientMonitor.checkoutClient();
            ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            ManagedObjectReference managedObjectReference = serviceContent.getConfigurationManagementService();
            ConfigurationManagementService configurationManagementService2 = configurationManagementService = (ConfigurationManagementService)VmomiClientHelper.createStub((Client)client, ConfigurationManagementService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            return configurationManagementService2;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
        finally {
            this._clientMonitor.releaseClient((Object)client);
        }
    }

    @Override
    public IdentitySourceManagementService getIdentitySourceManagementService() throws SsoServiceException {
        Client client = null;
        try {
            IdentitySourceManagementService identitySourceManagementService;
            client = (Client)this._clientMonitor.checkoutClient();
            ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            ManagedObjectReference managedObjectReference = serviceContent.getIdentitySourceManagementService();
            IdentitySourceManagementService identitySourceManagementService2 = identitySourceManagementService = (IdentitySourceManagementService)VmomiClientHelper.createStub((Client)client, IdentitySourceManagementService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            return identitySourceManagementService2;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
        finally {
            this._clientMonitor.releaseClient((Object)client);
        }
    }

    @Override
    public PasswordPolicyService getPasswordPolicyService() throws SsoServiceException {
        Client client = null;
        try {
            PasswordPolicyService passwordPolicyService;
            client = (Client)this._clientMonitor.checkoutClient();
            ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            ManagedObjectReference managedObjectReference = serviceContent.getPasswordPolicyService();
            PasswordPolicyService passwordPolicyService2 = passwordPolicyService = (PasswordPolicyService)VmomiClientHelper.createStub((Client)client, PasswordPolicyService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            return passwordPolicyService2;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
        finally {
            this._clientMonitor.releaseClient((Object)client);
        }
    }

    @Override
    public PrincipalDiscoveryService getPrincipalDiscoveryService() throws SsoServiceException {
        Client client = null;
        try {
            PrincipalDiscoveryService principalDiscoveryService;
            client = (Client)this._clientMonitor.checkoutClient();
            ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            ManagedObjectReference managedObjectReference = serviceContent.getPrincipalDiscoveryService();
            PrincipalDiscoveryService principalDiscoveryService2 = principalDiscoveryService = (PrincipalDiscoveryService)VmomiClientHelper.createStub((Client)client, PrincipalDiscoveryService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            return principalDiscoveryService2;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
        finally {
            this._clientMonitor.releaseClient((Object)client);
        }
    }

    @Override
    public PrincipalManagementService getPrincipalManagementService() throws SsoServiceException {
        Client client = null;
        try {
            PrincipalManagementService principalManagementService;
            client = (Client)this._clientMonitor.checkoutClient();
            ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            ManagedObjectReference managedObjectReference = serviceContent.getPrincipalManagementService();
            PrincipalManagementService principalManagementService2 = principalManagementService = (PrincipalManagementService)VmomiClientHelper.createStub((Client)client, PrincipalManagementService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            return principalManagementService2;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
        finally {
            this._clientMonitor.releaseClient((Object)client);
        }
    }

    @Override
    public RoleManagementService getRoleManagementService() throws SsoServiceException {
        Client client = null;
        try {
            RoleManagementService roleManagementService;
            client = (Client)this._clientMonitor.checkoutClient();
            ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            ManagedObjectReference managedObjectReference = serviceContent.getRoleManagementService();
            RoleManagementService roleManagementService2 = roleManagementService = (RoleManagementService)VmomiClientHelper.createStub((Client)client, RoleManagementService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            return roleManagementService2;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
        finally {
            this._clientMonitor.releaseClient((Object)client);
        }
    }

    @Override
    public void logout() throws SsoServiceException {
        try {
            this._clientMonitor.shutdown();
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
    }

    @Override
    public LockoutPolicyService getLockoutPolicyService() throws SsoServiceException {
        Client client = null;
        try {
            LockoutPolicyService lockoutPolicyService;
            client = (Client)this._clientMonitor.checkoutClient();
            ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            ManagedObjectReference managedObjectReference = serviceContent.getLockoutPolicyService();
            LockoutPolicyService lockoutPolicyService2 = lockoutPolicyService = (LockoutPolicyService)VmomiClientHelper.createStub((Client)client, LockoutPolicyService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            return lockoutPolicyService2;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
        finally {
            this._clientMonitor.releaseClient((Object)client);
        }
    }

    @Override
    public SystemManagementService getSystemManagementService() throws SsoServiceException {
        Client client = null;
        try {
            SystemManagementService systemManagementService;
            client = (Client)this._clientMonitor.checkoutClient();
            ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            ManagedObjectReference managedObjectReference = serviceContent.getSystemManagementService();
            SystemManagementService systemManagementService2 = systemManagementService = (SystemManagementService)VmomiClientHelper.createStub((Client)client, SystemManagementService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            return systemManagementService2;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
        finally {
            this._clientMonitor.releaseClient((Object)client);
        }
    }

    @Override
    public ComputerManagementService getComputerManagementService() throws SsoServiceException {
        Client client = null;
        try {
            ComputerManagementService computerManagementService;
            client = (Client)this._clientMonitor.checkoutClient();
            ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            ManagedObjectReference managedObjectReference = serviceContent.getComputerManagementService();
            ComputerManagementService computerManagementService2 = computerManagementService = (ComputerManagementService)VmomiClientHelper.createStub((Client)client, ComputerManagementService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            return computerManagementService2;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
        finally {
            this._clientMonitor.releaseClient((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ManagedObject> T getManagedObject(Class<T> clazz, ManagedObjectReference managedObjectReference) {
        Client client = null;
        try {
            ManagedObject managedObject;
            client = (Client)this._clientMonitor.checkoutClient();
            ManagedObject managedObject2 = managedObject = VmomiClientHelper.createStub((Client)client, clazz, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            return (T)managedObject2;
        }
        catch (Exception exception) {
            _logger.warn((Object)"Exception while getting ManagedObject", (Throwable)exception);
            T t = null;
            return t;
        }
        finally {
            this._clientMonitor.releaseClient((Object)client);
        }
    }

    private static ClientAuthenticator<Client> getAuthenticator(SsoServerInfo ssoServerInfo, SsoService ssoService, SamlToken samlToken, HttpSession httpSession) {
        if (samlToken == null) {
            return NON_AUTHENTICATING_CLIENT_MONITOR;
        }
        TokenClientAuthenticator tokenClientAuthenticator = new TokenClientAuthenticator(ssoServerInfo, ssoService, samlToken, httpSession);
        return tokenClientAuthenticator;
    }

    private static ClientAuthenticator<Client> getAuthenticator(SsoServerInfo ssoServerInfo, SsoSolutionUser ssoSolutionUser) {
        SamlToken samlToken = ssoSolutionUser.getLoggedInToken();
        if (samlToken == null) {
            return NON_AUTHENTICATING_CLIENT_MONITOR;
        }
        SolutionUserAuthenticator solutionUserAuthenticator = new SolutionUserAuthenticator(ssoServerInfo, ssoSolutionUser);
        return solutionUserAuthenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processLogout(Client client) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{client});
        try {
            ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            ManagedObjectReference managedObjectReference = serviceContent.getSessionManager();
            SessionManager sessionManager = (SessionManager)VmomiClientHelper.createStub((Client)client, SessionManager.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            sessionManager.logout();
        }
        finally {
            client.shutdown();
        }
    }

    private static class RequestRetryCallbackImpl
    implements RequestRetryCallback {
        private static final int MAX_RETRIES = 3;
        private volatile ClientMonitor<Client> _clientMonitor;

        private RequestRetryCallbackImpl() {
        }

        public boolean retry(Exception exception, InvocationContext invocationContext, int n) {
            if (!(exception instanceof NotAuthenticated) || n >= 3) {
                return false;
            }
            ClientMonitor<Client> clientMonitor = this._clientMonitor;
            if (clientMonitor == null) {
                return false;
            }
            try {
                clientMonitor.authenticate();
                return true;
            }
            catch (Exception exception2) {
                _logger.error((Object)"Exception while re-authenticating", (Throwable)exception2);
                return false;
            }
        }
    }

    private static class NonAuthenticatingAuthenticator
    implements ClientAuthenticator<Client> {
        private NonAuthenticatingAuthenticator() {
        }

        public void authenticate(Client client) {
        }

        public void logout(Client client) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{client});
            client.shutdown();
        }
    }

    private static class SolutionUserAuthenticator
    implements ClientAuthenticator<Client> {
        private final SsoServerInfo _ssoInfo;
        private final SsoSolutionUser _ssoSolutionUser;

        SolutionUserAuthenticator(SsoServerInfo ssoServerInfo, SsoSolutionUser ssoSolutionUser) {
            this._ssoInfo = ssoServerInfo;
            this._ssoSolutionUser = ssoSolutionUser;
        }

        public void authenticate(Client client) throws Exception {
            SamlToken samlToken = this._ssoSolutionUser.getLoggedInToken();
            SsoAdminServiceImpl.processLogin(client, this._ssoInfo, samlToken, this._ssoSolutionUser.getPrivateKey());
        }

        public void logout(Client client) throws Exception {
            SsoAdminServiceImpl.processLogout(client);
        }
    }

    private static class TokenClientAuthenticator
    implements ClientAuthenticator<Client> {
        private final SsoServerInfo _ssoInfo;
        private final SsoService _ssoService;
        private final SamlToken _token;
        private final HttpSession _session;
        private final AtomicBoolean _isFirstAttempt = new AtomicBoolean(true);

        TokenClientAuthenticator(SsoServerInfo ssoServerInfo, SsoService ssoService, SamlToken samlToken, HttpSession httpSession) {
            this._ssoInfo = ssoServerInfo;
            this._ssoService = ssoService;
            this._token = samlToken;
            this._session = httpSession;
        }

        public void authenticate(Client client) throws Exception {
            boolean bl = this._isFirstAttempt.getAndSet(false);
            SamlToken samlToken = this._token;
            if (!bl) {
                samlToken = AuthSessionUtil.getSsoToken();
                if (samlToken == null) {
                    samlToken = AuthSessionUtil.getSsoToken((HttpSession)this._session);
                }
                if (samlToken == null) {
                    throw new IllegalStateException("No token for the retry.");
                }
            }
            SsoAdminServiceImpl.processLogin(client, this._ssoInfo, samlToken, this._ssoService.getHokPrivateKey());
        }

        public void logout(Client client) throws Exception {
            SsoAdminServiceImpl.processLogout(client);
        }
    }
}

