/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.identity.cdc.CdcState;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.cdc.CdcData;
import com.vmware.vise.vim.cdc.CdcDataProvider;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.connections.SiteAffinityServerEndpointProvider;
import com.vmware.vise.vim.internal.Config;
import com.vmware.vise.vim.security.sso.SsoLocator;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoCmLocatorImpl
implements SsoLocator {
    private final ComponentManagerService _cmService;
    private final KeystoreService _ksService;
    private final Class<?> _vmodlVersion;
    @Nonnull
    private final CdcDataProvider _cdcDataProvider;
    private static final Log _logger = LogFactory.getLog(SsoCmLocatorImpl.class);
    private static final String METADATA_PATH = "/websso/SAML2/Metadata";
    private static final String STS_PATH = "/sts/STSService";
    private static final long LOCK_ACQUISITION_THRESHOLD_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private volatile CachedData _cachedData;

    public SsoCmLocatorImpl(ComponentManagerService componentManagerService, KeystoreService keystoreService) {
        this(componentManagerService, keystoreService, null);
    }

    public SsoCmLocatorImpl(ComponentManagerService componentManagerService, KeystoreService keystoreService, Class<?> clazz) {
        this(componentManagerService, keystoreService, clazz, null);
    }

    public SsoCmLocatorImpl(ComponentManagerService componentManagerService, KeystoreService keystoreService, Class<?> clazz, @Nullable CdcDataProvider cdcDataProvider) {
        this._cmService = componentManagerService;
        this._ksService = keystoreService;
        this._vmodlVersion = clazz;
        if (cdcDataProvider == null) {
            cdcDataProvider = new SiteAffinityServerEndpointProvider(null);
        }
        this._cdcDataProvider = cdcDataProvider;
    }

    @CheckForNull
    private CdcData getCdcDataNoException() {
        try {
            CdcData cdcData = this._cdcDataProvider.getCdcData();
            return cdcData;
        }
        catch (RuntimeException runtimeException) {
            _logger.error((Object)"Failed to determine the affinitized PSC host", (Throwable)runtimeException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SsoServerInfo getSsoServerInfo() throws Exception {
        Object object;
        ServiceInfo[] serviceInfoArray;
        long l;
        Object object2;
        long l2;
        String string;
        CdcState cdcState;
        long l3 = System.currentTimeMillis();
        String string2 = this._cmService.getServiceUrl();
        CdcData cdcData = this.getCdcDataNoException();
        if (cdcData != null) {
            cdcState = cdcData.getCdcState();
            string = cdcData.getAffinitizedDcHostName();
        } else {
            cdcState = null;
            string = null;
        }
        CachedData cachedData = this.getValidCachedData(string2, cdcState, string);
        if (cachedData == null) {
            l2 = System.nanoTime();
            object2 = this;
            synchronized (object2) {
                l = System.nanoTime() - l2;
                if (l > LOCK_ACQUISITION_THRESHOLD_NANOS) {
                    _logger.warn((Object)("getSsoServerInfo(): Lock acquisition took too long: " + TimeUnit.NANOSECONDS.toMillis(l) + " ms"));
                }
                if ((cachedData = this.getValidCachedData(string2, cdcState, string)) == null) {
                    _logger.info((Object)"Fetching SSO endpoints from CM");
                    serviceInfoArray = this._cmService.searchSso();
                    _logger.debug((Object)"Done with the cmService invocation");
                    object = this.buildSsoServerInfoFromServiceInfos(serviceInfoArray);
                    this._cachedData = cachedData = new CachedData(string2, cdcState, string, (SsoServerInfo)object);
                }
            }
        }
        l2 = System.currentTimeMillis();
        object2 = cachedData.getSsoServerInfo();
        l = l2 - l3;
        serviceInfoArray = new StringBuilder().append("Retrieved locations of services from CM at ").append(this._cmService.getServiceUrl()).append(" in ").append(l).append(" milliseconds:\n");
        if (_logger.isDebugEnabled()) {
            serviceInfoArray.append(((SsoServerInfo)object2).toExtendedString());
        } else {
            serviceInfoArray.append(((SsoServerInfo)object2).toString());
        }
        if (l > 10000L) {
            object = ExceptionUtil.getCurrentStackTrace();
            serviceInfoArray.append('\n').append((String)object);
            _logger.warn((Object)serviceInfoArray.toString());
        } else {
            _logger.info((Object)serviceInfoArray.toString());
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private SsoServerInfo buildSsoServerInfoFromServiceInfos(ServiceInfo[] serviceInfoArray) throws Exception {
        void var14_18;
        Object object;
        URI uRI = null;
        URI uRI2 = null;
        URI uRI3 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        for (ServiceInfo serviceInfo : serviceInfoArray) {
            object = serviceInfo.getServiceEndPoints();
            if (object == null || ((ServiceEndPoint[])object).length == 0) continue;
            block11: for (ServiceEndPoint serviceEndPoint : object) {
                String string7;
                switch (string7 = serviceEndPoint.getEndPointType().getTypeId()) {
                    case "com.vmware.cis.cs.identity.admin": {
                        URI uRI4 = serviceEndPoint.getUrl();
                        if (uRI4 == null) continue block11;
                        String string8 = uRI4.toString();
                        if (uRI == null) {
                            uRI = uRI4;
                            string = string8;
                            string4 = serviceEndPoint.getSslTrust()[0];
                        }
                        hashSet.add(string8);
                        continue block11;
                    }
                    case "com.vmware.cis.cs.identity.sso": {
                        URI uRI4 = serviceEndPoint.getUrl();
                        if (uRI4 == null) continue block11;
                        String string8 = uRI4.toString();
                        if (uRI2 == null) {
                            uRI2 = uRI4;
                            string2 = string8;
                            string5 = serviceEndPoint.getSslTrust()[0];
                        }
                        hashSet2.add(string8);
                        continue block11;
                    }
                    case "com.vmware.cis.cs.identity.websso": {
                        URI uRI4 = serviceEndPoint.getUrl();
                        if (uRI4 == null) continue block11;
                        String string8 = uRI4.toString();
                        if (uRI3 == null) {
                            uRI3 = uRI4;
                            string3 = string8;
                            string6 = serviceEndPoint.getSslTrust()[0];
                        }
                        hashSet3.add(string8);
                        continue block11;
                    }
                }
            }
        }
        if (string3 == null && string2 != null) {
            string3 = string2.toString().replace(STS_PATH, METADATA_PATH);
            uRI3 = URI.create(string3);
            string6 = string5;
        }
        Object var14_15 = null;
        X509Certificate x509Certificate = null;
        Object object2 = null;
        if (string5 != null) {
            x509Certificate = (X509Certificate)CertificateUtil.generateCertificate(string5);
        }
        if (string4 != null) {
            if (string4.equals(string5)) {
                X509Certificate x509Certificate2 = x509Certificate;
            } else {
                X509Certificate x509Certificate3 = (X509Certificate)CertificateUtil.generateCertificate((String)string4);
            }
        }
        if (string6 != null) {
            object2 = string6.equals(string5) ? x509Certificate : (string6.equals(string4) ? var14_18 : (X509Certificate)CertificateUtil.generateCertificate((String)string6));
        }
        SsoServerInfo.Builder builder = new SsoServerInfo.Builder();
        builder.keyStore = this._ksService.getKeyStore();
        builder.sslCertificate = x509Certificate;
        builder.vmodlVersion = this._vmodlVersion;
        builder.adminAppUrl = string;
        builder.adminAppSslCertificate = var14_18;
        builder.allAdminAppUrls = hashSet.isEmpty() ? null : hashSet;
        builder.stsUrl = string2;
        builder.sslCertificate = x509Certificate;
        builder.allStsUrls = hashSet2.isEmpty() ? null : hashSet2;
        builder.metadataUrl = string3;
        builder.metadataSslCertificate = object2;
        builder.allMetadataUrls = hashSet3.isEmpty() ? null : hashSet3;
        object = builder.getInstance();
        return object;
    }

    @CheckForNull
    private CachedData getValidCachedData(String string, CdcState cdcState, String string2) {
        boolean bl;
        boolean bl2;
        CachedData cachedData = this._cachedData;
        if (cachedData == null) {
            return null;
        }
        if (System.nanoTime() - cachedData.getCreatedOnNanos() >= Config.SSO_CACHE_REFRESH_INTERVAL_IN_NANOS) {
            return null;
        }
        String string3 = cachedData.getCmServiceUrl();
        boolean bl3 = bl2 = string3 != null ? string3.equals(string) : false;
        if (!bl2) {
            return null;
        }
        CdcState cdcState2 = cachedData.getCdcState();
        if (cdcState != cdcState2) {
            return null;
        }
        String string4 = cachedData.getCdcHostName();
        boolean bl4 = string2 != null ? string2.equals(string4) : (bl = string4 == null);
        if (bl) {
            return cachedData;
        }
        return null;
    }

    @Immutable
    private class CachedData {
        private final String _cmServiceUrl;
        private final CdcState _cdcState;
        private final String _cdcHostName;
        private final SsoServerInfo _ssoServerInfo;
        private final long _createdOnNanos;

        public CachedData(String string, CdcState cdcState, String string2, SsoServerInfo ssoServerInfo) {
            this._cmServiceUrl = string;
            this._cdcState = cdcState;
            this._cdcHostName = string2;
            this._ssoServerInfo = ssoServerInfo;
            this._createdOnNanos = System.nanoTime();
        }

        public String getCmServiceUrl() {
            return this._cmServiceUrl;
        }

        public CdcState getCdcState() {
            return this._cdcState;
        }

        public String getCdcHostName() {
            return this._cdcHostName;
        }

        public SsoServerInfo getSsoServerInfo() {
            return this._ssoServerInfo;
        }

        public long getCreatedOnNanos() {
            return this._createdOnNanos;
        }
    }
}

