/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.vmware.vapi.bindings.client.RetryPolicy;
import com.vmware.vapi.client.exception.TransportProtocolException;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.std.errors.Unauthenticated;
import com.vmware.vise.vim.vapi.VapiConnectionControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultVapiConnectionControl
implements VapiConnectionControl {
    private static final Log _logger = LogFactory.getLog(DefaultVapiConnectionControl.class);
    private static final int OPERATION_MAX_RETRIES = 1;

    @Override
    public boolean retryOnError(RuntimeException runtimeException, RetryPolicy.RetryContext retryContext, int n) {
        if (n >= 1) {
            _logger.error((Object)("Maximum number of attempts reached while trying to call " + retryContext.getServiceId() + "." + retryContext.getOperationId()));
            return false;
        }
        boolean bl = runtimeException instanceof Unauthenticated || runtimeException instanceof TransportProtocolException;
        return bl;
    }

    @Override
    public ApiProvider getApiProvider(ApiProvider apiProvider) {
        return apiProvider;
    }
}

