/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.vmware.vapi.bindings.Service;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.vapi.EndpointInfo;
import com.vmware.vise.vim.vapi.StaticEndpointVapiConnectionManager;
import com.vmware.vise.vim.vapi.VapiConnectionAuthenticationStrategy;
import com.vmware.vise.vim.vapi.VapiConnectionAuthenticationStrategyFactory;
import com.vmware.vise.vim.vapi.VapiConnectionControl;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostBasedVapiConnectionManagerRegistry
implements VapiConnectionManagerRegistry<String> {
    private static final Log _logger = LogFactory.getLog(HostBasedVapiConnectionManagerRegistry.class);
    private final KeystoreService _ksService;
    private final ExecutorService _asyncCallExecutor;
    private final ComponentManagerService _cmService;
    private volatile Map<String, URI> _endpointByHost;
    private final ConcurrentMap<String, VapiConnectionManager> _connectionManagerByHost;
    private final EndpointInfo _endpointType;
    private final VapiConnectionManagerRegistry.ControlFactory<String> _controlFactory;
    private final VapiConnectionAuthenticationStrategyFactory _authnStrategyFactory;

    public HostBasedVapiConnectionManagerRegistry(KeystoreService keystoreService, ExecutorService executorService, ComponentManagerService componentManagerService, EndpointInfo endpointInfo, VapiConnectionManagerRegistry.ControlFactory<String> controlFactory, VapiConnectionAuthenticationStrategyFactory vapiConnectionAuthenticationStrategyFactory) {
        Validate.notNull((Object)keystoreService);
        Validate.notNull((Object)executorService);
        Validate.notNull((Object)componentManagerService);
        Validate.notNull((Object)endpointInfo);
        Validate.notNull(controlFactory);
        Validate.notNull((Object)vapiConnectionAuthenticationStrategyFactory);
        this._ksService = keystoreService;
        this._asyncCallExecutor = executorService;
        this._cmService = componentManagerService;
        this._endpointType = endpointInfo;
        this._controlFactory = controlFactory;
        this._connectionManagerByHost = new ConcurrentHashMap<String, VapiConnectionManager>();
        this._endpointByHost = null;
        this._authnStrategyFactory = vapiConnectionAuthenticationStrategyFactory;
    }

    @Override
    public <C extends Service> C getService(Class<C> clazz, String string) {
        VapiConnectionManager vapiConnectionManager = this.getConnectionManager(string);
        if (vapiConnectionManager == null) {
            return null;
        }
        return (C)vapiConnectionManager.createServiceStub(clazz);
    }

    @Override
    public VapiConnectionManager getConnectionManager(String string) {
        VapiConnectionManager vapiConnectionManager;
        if (this._connectionManagerByHost.containsKey(string)) {
            vapiConnectionManager = (VapiConnectionManager)this._connectionManagerByHost.get(string);
        } else {
            VapiConnectionManager vapiConnectionManager2 = this.createVapiConnectionManagerForHost(string);
            if (vapiConnectionManager2 != null) {
                this._connectionManagerByHost.putIfAbsent(string, vapiConnectionManager2);
            }
            vapiConnectionManager = (VapiConnectionManager)this._connectionManagerByHost.get(string);
        }
        return vapiConnectionManager;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        for (VapiConnectionManager vapiConnectionManager : this._connectionManagerByHost.values()) {
            vapiConnectionManager.sessionEnded(httpSessionEvent);
        }
    }

    private VapiConnectionManager createVapiConnectionManagerForHost(String string) {
        URI uRI = this.getEndpoint(string);
        if (uRI == null) {
            _logger.debug((Object)String.format("Unable to find endpoint of type '%s' on host '%s'.", this._endpointType.toString(), string));
            return null;
        }
        VapiConnectionAuthenticationStrategy vapiConnectionAuthenticationStrategy = this._authnStrategyFactory.createAuthenticationStrategy(uRI);
        VapiConnectionControl vapiConnectionControl = this._controlFactory.getControlForEndpoint(string);
        StaticEndpointVapiConnectionManager staticEndpointVapiConnectionManager = new StaticEndpointVapiConnectionManager(uRI, this._ksService, this._asyncCallExecutor, vapiConnectionAuthenticationStrategy, vapiConnectionControl);
        return staticEndpointVapiConnectionManager;
    }

    private URI getEndpoint(String string) {
        if (this._endpointByHost == null) {
            this.retrieveEndpoints();
        }
        if (this._endpointByHost == null) {
            return null;
        }
        return this._endpointByHost.get(string);
    }

    private synchronized void retrieveEndpoints() {
        ServiceInfo[] serviceInfoArray;
        if (this._endpointByHost != null) {
            return;
        }
        try {
            serviceInfoArray = this.retrieveServices();
            if (serviceInfoArray == null) {
                serviceInfoArray = new ServiceInfo[]{};
            }
        }
        catch (ComponentManagerFault componentManagerFault) {
            _logger.error((Object)"Could not retrieve services from CM", (Throwable)componentManagerFault);
            return;
        }
        HashMap<String, URI> hashMap = new HashMap<String, URI>();
        for (ServiceInfo serviceInfo : serviceInfoArray) {
            if (serviceInfo.getServiceEndPoints().length > 1) {
                _logger.warn((Object)"Found more than one endpoint of type on host.");
            }
            ServiceEndPoint serviceEndPoint = serviceInfo.getServiceEndPoints()[0];
            URI uRI = serviceEndPoint.getUrl();
            String string = uRI.getHost();
            hashMap.put(string, uRI);
        }
        this._endpointByHost = hashMap;
    }

    private ServiceInfo[] retrieveServices() throws ComponentManagerFault {
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        searchCriteriaImpl.setServiceType((ServiceType)new ServiceTypeImpl(this._endpointType.getProductId(), this._endpointType.getServiceTypeId()));
        searchCriteriaImpl.setEndPointType((ServiceEndPointType)new ServiceEndPointTypeImpl(this._endpointType.getEndpointProtocolId(), this._endpointType.getEndpointTypeId()));
        return this._cmService.search((SearchCriteria)searchCriteriaImpl);
    }
}

