/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.google.common.base.Preconditions;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vise.util.OpIdUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.vim.vapi.OpIdProxyAsyncHandle;
import java.util.HashMap;
import org.apache.commons.logging.Log;

public class OpIdProxyApiProvider
implements ApiProvider {
    private static final Log _opIdLogger = LogUtil.getOpIdLogger();
    public static final String OPID_FIELD = "opId";
    private final ApiProvider _provider;

    public OpIdProxyApiProvider(ApiProvider apiProvider) {
        Preconditions.checkNotNull((Object)apiProvider, (Object)"provider is null");
        Preconditions.checkNotNull((Object)apiProvider, (Object)"endpointInfo is null");
        this._provider = apiProvider;
    }

    public void invoke(String string, String string2, DataValue dataValue, ExecutionContext executionContext, AsyncHandle<MethodResult> asyncHandle) {
        String string3 = OpIdUtil.generateOpId();
        HashMap<String, String> hashMap = new HashMap<String, String>(executionContext.retrieveApplicationData().getAllProperties());
        hashMap.put(OPID_FIELD, string3);
        ExecutionContext executionContext2 = new ExecutionContext(new ExecutionContext.ApplicationData(hashMap), executionContext.retrieveSecurityContext());
        long l = System.nanoTime();
        OpIdProxyAsyncHandle<MethodResult> opIdProxyAsyncHandle = new OpIdProxyAsyncHandle<MethodResult>(asyncHandle, string, string2, string3, l);
        if (_opIdLogger.isDebugEnabled()) {
            _opIdLogger.debug((Object)("Invoking vAPI: serviceId=" + string + ", operationId=" + string2 + ", opId=" + string3 + "  (" + OpIdProxyApiProvider.class.getName() + ")"));
        }
        this._provider.invoke(string, string2, dataValue, executionContext2, opIdProxyAsyncHandle);
    }
}

