/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.data.DataValue;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.vim.internal.Config;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;

public class OpIdProxyAsyncHandle<T>
extends AsyncHandle<T> {
    private static final Log _opIdLogger = LogUtil.getOpIdLogger();
    private final AsyncHandle<T> _handle;
    private final String _serviceId;
    private final String _operationId;
    private final String _opId;
    private final long _invocationStartInNanos;

    public OpIdProxyAsyncHandle(AsyncHandle<T> asyncHandle, String string, String string2, String string3, long l) {
        this._handle = asyncHandle;
        this._serviceId = string;
        this._operationId = string2;
        this._opId = string3;
        this._invocationStartInNanos = l;
    }

    public void updateProgress(DataValue dataValue) {
        this._handle.updateProgress(dataValue);
    }

    public void setResult(T t) {
        this.logInvocationCompletion(t, null);
        this._handle.setResult(t);
    }

    public void setError(RuntimeException runtimeException) {
        this.logInvocationCompletion(null, runtimeException);
        this._handle.setError(runtimeException);
    }

    private void logInvocationCompletion(T t, RuntimeException runtimeException) {
        long l = System.nanoTime() - this._invocationStartInNanos;
        long l2 = TimeUnit.NANOSECONDS.toMillis(l);
        StringBuilder stringBuilder = new StringBuilder().append("The vAPI invocation of serviceId '").append(this._serviceId).append("' and operationId '").append(this._operationId).append("' for opId '").append(this._opId);
        if (runtimeException != null) {
            stringBuilder.append("' failed in ").append(l2).append(" ms: ");
            if (_opIdLogger.isTraceEnabled()) {
                _opIdLogger.error((Object)stringBuilder.toString(), (Throwable)runtimeException);
            } else {
                _opIdLogger.error((Object)(stringBuilder.toString() + runtimeException.toString()));
            }
        } else if (t instanceof Throwable) {
            stringBuilder.append("' finished in ").append(l2).append(" ms with a result that is a Throwable: ");
            if (_opIdLogger.isDebugEnabled()) {
                Throwable throwable = (Throwable)t;
                throwable = ExceptionUtil.unwrap((Throwable)throwable);
                _opIdLogger.debug((Object)stringBuilder.toString(), throwable);
            } else {
                _opIdLogger.info((Object)(stringBuilder.toString() + t.toString()));
            }
        } else if (Config.VAPI_OPERATION_INVOCATION_THRESHOLD_NANOS >= 0L && l > Config.VAPI_OPERATION_INVOCATION_THRESHOLD_NANOS) {
            stringBuilder.append("' took too long: ").append(l2).append(" ms");
            _opIdLogger.warn((Object)stringBuilder.toString());
        } else if (_opIdLogger.isDebugEnabled()) {
            stringBuilder.append("' completed in ").append(l2).append(" ms");
            _opIdLogger.debug((Object)stringBuilder.toString());
        }
    }
}

