/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.datastore;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmfsDatastoreExtentItem;
import com.vmware.vsphere.client.storage.VmfsExtentInfo;
import com.vmware.vsphere.client.storage.util.StorageUtil;

@QueryBinding(value="Datastore")
public class VmfsDatastoreExtentData {
    @Property(value="Datastore/vmfsDatastoreExtents")
    public transient VmfsExtentInfo[] extentInfos;

    public VmfsDatastoreExtentItem[] getDatastoreExtentItems() {
        VmfsDatastoreExtentItem[] extentItems = new VmfsDatastoreExtentItem[this.extentInfos.length];
        for (int i = 0; i < this.extentInfos.length; ++i) {
            VmfsExtentInfo currentExtentInfo = this.extentInfos[i];
            extentItems[i] = new VmfsDatastoreExtentItem();
            extentItems[i].formattedName = this.getName(currentExtentInfo);
            extentItems[i].capacityInB = this.getCapacity(currentExtentInfo);
            extentItems[i].formattedCapacity = FormatUtil.getStorageFormatted((Long)extentItems[i].capacityInB, (long)1L, (long)-1L);
        }
        return extentItems;
    }

    private String getName(VmfsExtentInfo extentInfo) {
        String name = extentInfo.deviceDisplayName != null ? extentInfo.deviceDisplayName : extentInfo.extentPartition.diskName;
        return String.format("%s : %d", name, extentInfo.extentPartition.partition);
    }

    private long getCapacity(VmfsExtentInfo extentInfo) {
        long unknownCapacity = 0L;
        for (DiskPartitionInfo.BlockRange blockRange : extentInfo.partitionInfo.layout.partition) {
            if (blockRange.partition != Integer.valueOf(extentInfo.extentPartition.partition)) continue;
            return StorageUtil.getSizeOfBlockRange((DiskPartitionInfo.BlockRange)blockRange);
        }
        return unknownCapacity;
    }
}

