/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.datastore;

import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreOption;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmfsDatastoreOptionItem;
import java.util.Arrays;
import java.util.Comparator;

public class VmfsDatastoreOptionData {
    public VmfsDatastoreOptionItem[] optionItems;
    private static final Comparator<VmfsDatastoreOptionItem> COMPARATOR = new Comparator<VmfsDatastoreOptionItem>(){

        @Override
        public int compare(VmfsDatastoreOptionItem item1, VmfsDatastoreOptionItem item2) {
            return Integer.compare(item2.priority, item1.priority);
        }
    };

    public static VmfsDatastoreOptionData newInstance(VmfsDatastoreOption[] options, DiskPartitionInfo partitionInfo) {
        VmfsDatastoreOptionItem[] transformed;
        VmfsDatastoreOptionData data = new VmfsDatastoreOptionData();
        if (options != null) {
            transformed = new VmfsDatastoreOptionItem[options.length];
            for (int i = 0; i < options.length; ++i) {
                transformed[i] = VmfsDatastoreOptionItem.newInstance(options[i], partitionInfo);
            }
            Arrays.sort(transformed, COMPARATOR);
        } else {
            transformed = new VmfsDatastoreOptionItem[]{};
        }
        data.optionItems = transformed;
        return data;
    }
}

