/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vsphere.client.h5.storage.data.datastore.HostConnectivityData;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmfsDatastoreConnectivityData;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmfsDatastoreConnectivityItem;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import java.util.ArrayList;

public class DatastoreConnectivityPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;

    public DatastoreConnectivityPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="connectivityWithHost", property="vmfsDatastoreConnectivity")
    public VmfsDatastoreConnectivityItem[] getVmfsDatastoreConnectivityWithHosts(ManagedObjectReference datastoreRef) {
        VmfsDatastoreConnectivityData dataserviceResponse = (VmfsDatastoreConnectivityData)((Object)this._queryBindingService.prepare(VmfsDatastoreConnectivityData.class).fetch((Object)datastoreRef));
        if (dataserviceResponse == null || dataserviceResponse.hostMounts == null || dataserviceResponse.hostsData == null) {
            return new VmfsDatastoreConnectivityItem[0];
        }
        ArrayList<VmfsDatastoreConnectivityItem> result = new ArrayList<VmfsDatastoreConnectivityItem>();
        for (HostConnectivityData connectivityData : dataserviceResponse.hostsData) {
            VmfsDatastoreConnectivityItem currentItem = new VmfsDatastoreConnectivityItem();
            currentItem.hostFormattedName = this.formatHostName(connectivityData.name, connectivityData.connectionState, connectivityData.powerState);
            Datastore.HostMount hostMount = this.findMountInfo(connectivityData, dataserviceResponse);
            currentItem.hostRef = hostMount.key;
            currentItem.isMounted = hostMount.mountInfo.mounted;
            currentItem.isAccessible = hostMount.mountInfo.accessible;
            currentItem.mountPoint = hostMount.mountInfo.path;
            result.add(currentItem);
        }
        return result.toArray(new VmfsDatastoreConnectivityItem[result.size()]);
    }

    private Datastore.HostMount findMountInfo(HostConnectivityData connectivityData, VmfsDatastoreConnectivityData dataserviceResponse) {
        for (Datastore.HostMount mountInfo : dataserviceResponse.hostMounts) {
            Object hostMor = connectivityData.provider;
            if (!mountInfo.key.equals(hostMor)) continue;
            return mountInfo;
        }
        return null;
    }

    private String formatHostName(String hostName, HostSystem.ConnectionState connectionState, HostSystem.PowerState powerState) {
        String hostState = null;
        if (connectionState == HostSystem.ConnectionState.notResponding) {
            hostState = powerState == HostSystem.PowerState.standBy ? StorageStringUtil.getString("hostState.standBy") : StorageStringUtil.getString("hostState.notResponding");
        } else if (connectionState == HostSystem.ConnectionState.disconnected) {
            hostState = StorageStringUtil.getString("hostState.disconnected");
        }
        if (hostState != null) {
            return String.format("%s (%s)", hostName, hostState);
        }
        return hostName;
    }
}

