/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.vim.binding.vim.DatastoreNamespaceManager;
import com.vmware.vim.binding.vim.FileManager;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.h5.storage.spec.DatastoreCreateFolderSpec;
import com.vmware.vsphere.client.h5.storage.spec.DatastoreDeleteFileSpec;
import com.vmware.vsphere.client.storage.util.DatastorePathUtil;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreFileMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DatastoreFileMutationProvider.class);
    private TaskMonitor _taskMonitor;

    public DatastoreFileMutationProvider(TaskMonitor taskMonitor) {
        this._taskMonitor = taskMonitor;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, DatastoreCreateFolderSpec spec) {
        spec.folderName = DatastorePathUtil.escapeDatastoreNameInPath((String)spec.folderName);
        OperationResult opResult = new OperationResult();
        opResult.entity = datastoreRef;
        try {
            String serverGuid = this.getServerGuid(datastoreRef);
            if (spec.isRootFolder && !spec.supportTopLevelDirectoryCreate) {
                DatastoreNamespaceManager dsNamespaceManager = this.getDatastoreNamespaceManager(serverGuid);
                dsNamespaceManager.CreateDirectory(datastoreRef, spec.folderName, spec.policy);
            } else {
                FileManager fileManager = this.getFileManager(serverGuid);
                fileManager.makeDirectory(spec.folderName, spec.datacenter, Boolean.valueOf(spec.createParentDirectories));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to create folder: ", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, DatastoreDeleteFileSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = datastoreRef;
        try {
            FileManager fileManager = this.getFileManager(this.getServerGuid(datastoreRef));
            if (spec.targetFiles == null) {
                return opResult;
            }
            for (int i = 0; i < spec.targetFiles.length; ++i) {
                spec.targetFiles[i] = DatastorePathUtil.escapeDatastoreNameInPath((String)spec.targetFiles[i]);
            }
            ArrayList<ManagedObjectReference> removeFileTasks = new ArrayList<ManagedObjectReference>();
            for (int i = 0; i < spec.targetFiles.length; ++i) {
                String targetFile = spec.targetFiles[i];
                try {
                    ManagedObjectReference task = fileManager.deleteFile(targetFile, spec.sourceDatacenter);
                    removeFileTasks.add(task);
                    continue;
                }
                catch (Exception e) {
                    _logger.error((Object)("Failed to remove file or folder " + targetFile + ": "), (Throwable)e);
                }
            }
            this._taskMonitor.monitorTasks(removeFileTasks);
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to remove file or folder: ", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private String getServerGuid(ManagedObjectReference moRef) {
        if (moRef == null) {
            return null;
        }
        return moRef.getServerGuid();
    }

    private FileManager getFileManager(String serverGuid) throws Exception {
        VcService service = VimSessionUtil.getService((String)serverGuid);
        ServiceInstance serviceInstance = service.getServiceInstance();
        ServiceInstanceContent sc = serviceInstance.retrieveContent();
        FileManager fileManager = (FileManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sc.fileManager);
        return fileManager;
    }

    private DatastoreNamespaceManager getDatastoreNamespaceManager(String serverGuid) throws Exception {
        VcService service = VimSessionUtil.getService((String)serverGuid);
        ServiceInstance serviceInstance = service.getServiceInstance();
        ServiceInstanceContent sc = serviceInstance.retrieveContent();
        DatastoreNamespaceManager dsNamespaceManager = (DatastoreNamespaceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sc.datastoreNamespaceManager);
        return dsNamespaceManager;
    }
}

