/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.host.DatastoreSystem;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.NasDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreOption;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.model.PropertyValueData;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmfsDatastoreOptionData;
import com.vmware.vsphere.client.h5.storage.spec.VmfsDatastoreCreateOptionQuerySpec;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import com.vmware.vsphere.client.h5.storage.util.StorageUtil;
import com.vmware.vsphere.client.storage.DatastoreIncreaseOptionsQuerySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastorePropertyProvider
implements PropertyProviderBean {
    private static final String HOST_DATASTORE_SYSTEM = "datastoreSystem";
    private static final String DISK_PARTITION_INFO = "diskPartitionInfo";
    private static final String DATACENTER_RELATION = "dc";
    private static final String DATASTORE_RELATION = "datastore";
    private static final String NAME_PROPERTY = "name";
    private static final String DATASTORE_INFO_PROPERTY = "info";
    private static final String DATASTORE_TYPE_PROPERTY = "summary.type";
    private static final String DATASTORE_FREE_SPACE_PROPERTY = "info.freeSpace";
    private static final String DATASTORE_CAPACITY_PROPERTY = "summary.capacity";
    private static final String DATASTORE_UNCOMMITED_PROPERTY = "summary.uncommitted";
    private static final String DATASTORE_ACCESSIBLE_PROPERTY = "summary.accessible";
    private static final String DATASTORE_THIN_PROVISIONING_CAPABILITY = "capability.perFileThinProvisioningSupported";
    private static final String DATASTORE_IORM_SUPPORTED_CAPABILITY = "capability.storageIORMSupported";
    private static final String DATASTORE_IORM_CONFIG_PROPERTY = "iormConfiguration";
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;
    private static final Log _logger = LogFactory.getLog(DatastorePropertyProvider.class);

    public DatastorePropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="datastore", property="vmfsDatastoreCreateOptionsData")
    public VmfsDatastoreOptionData getVmfsDatastoreCreateOptionsData(ManagedObjectReference hostRef, VmfsDatastoreCreateOptionQuerySpec spec) throws Exception {
        Map<String, Object> hostProperties = this.getDatastoreSystemAndPartitionInfo(hostRef, spec.devicePath);
        ManagedObjectReference datastoreSystemMor = (ManagedObjectReference)hostProperties.get(HOST_DATASTORE_SYSTEM);
        DatastoreSystem datastoreSystem = (DatastoreSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)datastoreSystemMor);
        DiskPartitionInfo diskPartitionInfo = (DiskPartitionInfo)hostProperties.get(DISK_PARTITION_INFO);
        if (datastoreSystem == null || diskPartitionInfo == null) {
            _logger.error((Object)"Failed to retrieve host's datastoreSystem/diskPartitionInfo");
            throw new IllegalArgumentException(StorageStringUtil.getString("error.failedToRetrieveHostInfo"));
        }
        VmfsDatastoreOption[] options = datastoreSystem.queryVmfsDatastoreCreateOptions(spec.devicePath, Integer.valueOf(spec.vmfsMajorVersion));
        return VmfsDatastoreOptionData.newInstance(options, diskPartitionInfo);
    }

    @ModelMetadata(type={"HostSystem", "Datacenter", "Folder", "ClusterComputeResource"}, propertyNamespace="datastore", property="datastoreInfoByDatastoreName")
    public Datastore.Info[] getDatastoreInfoByDatastoreName(ManagedObjectReference moRef, String datastoreName) throws Exception {
        Object dcConstraint = ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, Datacenter.class) ? this._querySpecBuilder.createObjectIdentityConstraint((Object)moRef) : this._querySpecBuilder.createConstraintForRelationship((Object)moRef, DATACENTER_RELATION, Datacenter.class.getSimpleName());
        RelationalConstraint datastoresInDcConstraint = this._querySpecBuilder.createRelationalConstraint(DATASTORE_RELATION, (Constraint)dcConstraint, Boolean.valueOf(true), Datastore.class.getSimpleName());
        PropertyConstraint datastoreNameConstraint = this._querySpecBuilder.createPropertyConstraint(Datastore.class.getSimpleName(), NAME_PROPERTY, Comparator.EQUALS, (Object)datastoreName);
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(this._querySpecBuilder.combineIntoSingleConstraint(new Constraint[]{datastoresInDcConstraint, datastoreNameConstraint}, Conjoiner.AND), new String[]{DATASTORE_INFO_PROPERTY});
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        ArrayList<Datastore.Info> datastoreInfos = new ArrayList<Datastore.Info>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem resultItem : resultSet.items) {
                if (resultItem.properties == null) continue;
                for (PropertyValue propValue : resultItem.properties) {
                    if (!DATASTORE_INFO_PROPERTY.equals(propValue.propertyName)) continue;
                    datastoreInfos.add((Datastore.Info)propValue.value);
                }
            }
        }
        return datastoreInfos.toArray(new Datastore.Info[datastoreInfos.size()]);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="datastoreIncreaseOptions")
    public VmfsDatastoreOptionData getVmfsDatastoreIncreaseOptions(ManagedObjectReference datastoreRef, DatastoreIncreaseOptionsQuerySpec spec) throws Exception {
        String INCREASE_OPTION_PROPERTY = "vmfsDatastoreIncreaseOptions";
        HashMap<String, Object> propertyParams = new HashMap<String, Object>();
        propertyParams.put(INCREASE_OPTION_PROPERTY, spec);
        Map<String, Object> result = StorageUtil.requestPropertiesWithParams(this._queryExecutor, this._querySpecBuilder, datastoreRef, new String[]{INCREASE_OPTION_PROPERTY}, propertyParams);
        VmfsDatastoreOption[] options = (VmfsDatastoreOption[])result.get(INCREASE_OPTION_PROPERTY);
        propertyParams.clear();
        propertyParams.put(DISK_PARTITION_INFO, spec.scsiDiskInfo.disk.devicePath);
        result = StorageUtil.requestPropertiesWithParams(this._queryExecutor, this._querySpecBuilder, spec.host, new String[]{DISK_PARTITION_INFO}, propertyParams);
        DiskPartitionInfo info = (DiskPartitionInfo)result.get(DISK_PARTITION_INFO);
        return VmfsDatastoreOptionData.newInstance(options, info);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="datastoreGeneralPropertiesData")
    public PropertyValueData[] getDatastoreGeneralPropertiesData(ManagedObjectReference dsRef) throws Exception {
        Map<String, Object> queryResult = StorageUtil.requestProperties(this._queryExecutor, dsRef, new String[]{DATASTORE_TYPE_PROPERTY, DATASTORE_INFO_PROPERTY});
        String dsType = (String)queryResult.get(DATASTORE_TYPE_PROPERTY);
        Datastore.Info dsInfo = (Datastore.Info)queryResult.get(DATASTORE_INFO_PROPERTY);
        ArrayList<PropertyValueData> datastorePropertyItems = new ArrayList<PropertyValueData>();
        if (dsInfo != null) {
            DatastorePropertyProvider.populateDatastoreNameProperty(datastorePropertyItems, dsInfo);
        }
        if (dsInfo != null && dsInfo instanceof VmfsDatastoreInfo) {
            DatastorePropertyProvider.populateVmfsDatastoreProperties(datastorePropertyItems, (VmfsDatastoreInfo)dsInfo);
        } else {
            if (dsType != null) {
                DatastorePropertyProvider.populateDatastoreTypeProperty(datastorePropertyItems, dsType);
            }
            if (dsInfo != null && dsInfo instanceof NasDatastoreInfo) {
                DatastorePropertyProvider.populateNfsDatastoreProperties(datastorePropertyItems, (NasDatastoreInfo)dsInfo);
            }
        }
        return datastorePropertyItems.toArray(new PropertyValueData[datastorePropertyItems.size()]);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="datastoreGeneralCapacityData")
    public PropertyValueData[] getDatastoreGeneralCapacityData(ManagedObjectReference dsRef) throws Exception {
        Long uncommitedSpace;
        Long usedSpace;
        Map<String, Object> queryResult = StorageUtil.requestProperties(this._queryExecutor, dsRef, new String[]{DATASTORE_CAPACITY_PROPERTY, DATASTORE_FREE_SPACE_PROPERTY, DATASTORE_ACCESSIBLE_PROPERTY, DATASTORE_UNCOMMITED_PROPERTY});
        Long datastoreCapacity = (Long)queryResult.get(DATASTORE_CAPACITY_PROPERTY);
        Long freeSpace = (Long)queryResult.get(DATASTORE_FREE_SPACE_PROPERTY);
        Long provisionedSpace = usedSpace = Long.valueOf(datastoreCapacity - freeSpace);
        Boolean isAccessible = (Boolean)queryResult.get(DATASTORE_ACCESSIBLE_PROPERTY);
        if (isAccessible != null && isAccessible.booleanValue() && (uncommitedSpace = (Long)queryResult.get(DATASTORE_UNCOMMITED_PROPERTY)) != null) {
            provisionedSpace = provisionedSpace + uncommitedSpace;
        }
        PropertyValueData[] result = new PropertyValueData[]{StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.totalCapacity", FormatUtil.getStorageFormatted((Long)datastoreCapacity, (long)1L, (long)-1L)), StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.provisionedSpace", FormatUtil.getStorageFormatted((Long)provisionedSpace, (long)1L, (long)-1L)), StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.freeSpace", FormatUtil.getStorageFormatted((Long)freeSpace, (long)1L, (long)-1L))};
        return result;
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="datastoreGeneralCapabilitiesData")
    public PropertyValueData[] getDatastoreGeneralCapabilitiesData(ManagedObjectReference dsRef) throws Exception {
        Map<String, Object> queryResult = StorageUtil.requestProperties(this._queryExecutor, dsRef, new String[]{DATASTORE_TYPE_PROPERTY, DATASTORE_THIN_PROVISIONING_CAPABILITY, DATASTORE_IORM_SUPPORTED_CAPABILITY, DATASTORE_IORM_CONFIG_PROPERTY});
        ArrayList<PropertyValueData> result = new ArrayList<PropertyValueData>();
        String dsType = (String)queryResult.get(DATASTORE_TYPE_PROPERTY);
        if (StorageUtil.isVmfsDsType(dsType)) {
            result.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.thinProvisioning", StorageUtil.formatSupportedValue((Boolean)queryResult.get(DATASTORE_THIN_PROVISIONING_CAPABILITY))));
        }
        DatastorePropertyProvider.populateIormProperties(result, (Boolean)queryResult.get(DATASTORE_IORM_SUPPORTED_CAPABILITY), (StorageResourceManager.IORMConfigInfo)queryResult.get(DATASTORE_IORM_CONFIG_PROPERTY));
        return result.toArray(new PropertyValueData[result.size()]);
    }

    private Map<String, Object> getDatastoreSystemAndPartitionInfo(ManagedObjectReference hostRef, String devicePath) throws Exception {
        HashMap<String, Object> propertyParams = new HashMap<String, Object>();
        propertyParams.put(DISK_PARTITION_INFO, devicePath);
        Map<String, Object> hostProperties = StorageUtil.requestPropertiesWithParams(this._queryExecutor, this._querySpecBuilder, hostRef, new String[]{HOST_DATASTORE_SYSTEM, DISK_PARTITION_INFO}, propertyParams);
        return hostProperties;
    }

    private static void populateDatastoreNameProperty(List<PropertyValueData> datastoreProperties, Datastore.Info info) {
        datastoreProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.name", info.name));
    }

    private static void populateDatastoreTypeProperty(List<PropertyValueData> datastoreProperties, String dsType) {
        datastoreProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.type", StorageUtil.formatDatastoreType(dsType)));
    }

    private static void populateNfsDatastoreProperties(List<PropertyValueData> datastoreProperties, NasDatastoreInfo info) {
        String maxFileSize = FormatUtil.getStorageFormatted((Long)info.maxFileSize, (long)1L, (long)-1L);
        datastoreProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.maxFileSize", maxFileSize));
        if (info.maxVirtualDiskCapacity != null) {
            String maxVmdkSize = FormatUtil.getStorageFormatted((Long)info.maxVirtualDiskCapacity, (long)1L, (long)-1L);
            datastoreProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.maxVmdkSize", maxVmdkSize));
        }
    }

    private static void populateVmfsDatastoreProperties(List<PropertyValueData> datastoreProperties, VmfsDatastoreInfo info) {
        String dsFileSystem = StorageStringUtil.getString("vmfsDatastore.version.format", info.vmfs.version);
        PropertyValueData fileSystemProp = StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.fileSystem", dsFileSystem);
        ArrayList<PropertyValueData> fileSystemPropNestedProperties = new ArrayList<PropertyValueData>();
        fileSystemPropNestedProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.type", dsFileSystem));
        String maxFileSize = FormatUtil.getStorageFormatted((Long)info.maxFileSize, (long)1L, (long)-1L);
        fileSystemPropNestedProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.maxFileSize", maxFileSize));
        String maxVmdkSize = FormatUtil.getStorageFormatted((Long)info.maxVirtualDiskCapacity, (long)1L, (long)-1L);
        fileSystemPropNestedProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.maxVmdkSize", maxVmdkSize));
        String blockSize = info.vmfs.blockSize != null ? FormatUtil.getStorageFormatted((Long)info.vmfs.blockSize.longValue(), (long)1024L, (long)-1L) : FormatUtil.getStorageFormatted((Long)Long.valueOf(info.vmfs.blockSizeMb), (long)0x100000L, (long)0x100000L);
        fileSystemPropNestedProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.blockSize", blockSize));
        fileSystemProp.nestedProperties = fileSystemPropNestedProperties.toArray(new PropertyValueData[fileSystemPropNestedProperties.size()]);
        datastoreProperties.add(fileSystemProp);
        datastoreProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.properties.driveType", StorageUtil.formatFlash(info.vmfs.ssd)));
    }

    private static void populateIormProperties(List<PropertyValueData> datastoreCapabilityProperties, Boolean iormSupportedCapability, StorageResourceManager.IORMConfigInfo iormConfigInfo) {
        String ioStatsExcluded;
        String iormMode;
        String iormStatus;
        String congestionThreshold = "";
        boolean includeCongestionThreshold = false;
        if (Boolean.TRUE.equals(iormSupportedCapability) && iormConfigInfo != null) {
            iormStatus = StorageUtil.formatEnabledValue(iormConfigInfo.enabled);
            boolean isAutomaticMode = StorageResourceManager.CongestionThresholdMode.automatic.toString().equals(iormConfigInfo.congestionThresholdMode);
            iormMode = DatastorePropertyProvider.formatIormMode(isAutomaticMode, iormConfigInfo);
            if (!isAutomaticMode) {
                includeCongestionThreshold = true;
                congestionThreshold = StorageStringUtil.getString("datastore.IORM.msThreshold", String.valueOf(iormConfigInfo.congestionThreshold));
            }
            boolean storageIORMStatsAggregationEnabled = iormConfigInfo.statsAggregationDisabled == null || iormConfigInfo.statsAggregationDisabled == false;
            ioStatsExcluded = StorageUtil.formatEnabledValue(storageIORMStatsAggregationEnabled);
        } else {
            String naText = StorageStringUtil.getString("na");
            iormStatus = StorageUtil.formatSupportedValue(false);
            iormMode = naText;
            congestionThreshold = naText;
            includeCongestionThreshold = true;
            ioStatsExcluded = naText;
        }
        ArrayList<PropertyValueData> nestedProperties = new ArrayList<PropertyValueData>();
        nestedProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.iormStatus", iormStatus));
        nestedProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.iormMode", iormMode));
        if (includeCongestionThreshold) {
            nestedProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.iormCongestionThreshold", congestionThreshold));
        }
        nestedProperties.add(StorageUtil.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.ioStatsExcluded", ioStatsExcluded));
        PropertyValueData iormPropertyItem = StorageUtil.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.iormControl", iormStatus);
        iormPropertyItem.nestedProperties = nestedProperties.toArray(new PropertyValueData[nestedProperties.size()]);
        datastoreCapabilityProperties.add(iormPropertyItem);
    }

    private static String formatIormMode(boolean isAutomaticMode, StorageResourceManager.IORMConfigInfo iormConfigInfo) {
        if (isAutomaticMode) {
            return StorageStringUtil.getString("datastore.manage.general.datastoreCapabilities.iormMode.automatic", iormConfigInfo.percentOfPeakThroughput.toString());
        }
        return StorageStringUtil.getString("datastore.manage.general.datastoreCapabilities.iormMode.manual");
    }
}

