/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.vim.binding.vim.host.FibreChannelHba;
import com.vmware.vim.binding.vim.host.FibreChannelOverEthernetHba;
import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.InternetScsiHba;
import com.vmware.vim.binding.vim.host.MultipathStateInfo;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.h5.storage.data.adapters.FcoeConfigData;
import com.vmware.vsphere.client.h5.storage.data.adapters.FibreChannelOverEthernetStorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.adapters.FibreChannelStorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.adapters.HostStorageAdapterPathsData;
import com.vmware.vsphere.client.h5.storage.data.adapters.HostStorageAdaptersData;
import com.vmware.vsphere.client.h5.storage.data.adapters.IscsiStorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.adapters.StorageAdapterData;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterTopologyCountData;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterType;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import com.vmware.vsphere.client.storage.util.HostStoragePropertyCache;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostStorageAdaptersPropertyProvider
implements PropertyProviderBean {
    private static final String STORAGE_DEVICE_INFO_PROPERTY = "config/storageDevice";
    private static final String STORAGE_MULTIPATH_INFO_PROPERTY = "config/multipathState";
    private static final String ISCSI_MANAGER_SUPPORTED = "iscsiManagerSupported";
    private static final String HOST_PNIC_PROPERTY = "config/network/pnic";
    private static final String COMMA_SEPARATOR = ", ";
    private static final int INVALID_LUN_NUMBER = -1;
    private static Log _logger = LogFactory.getLog(HostStorageAdaptersPropertyProvider.class);
    private QueryExecutor _queryExecutor;

    public HostStorageAdaptersPropertyProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="hostStorageAdapters")
    public HostStorageAdaptersData getHostStorageAdapters(ManagedObjectReference hostRef) throws Exception {
        HostStorageAdaptersData result = new HostStorageAdaptersData();
        result.adapters = new StorageAdapterData[0];
        if (hostRef == null) {
            _logger.error((Object)"Host is null.");
            return result;
        }
        Map<String, Object> properties = com.vmware.vsphere.client.h5.storage.util.StorageUtil.requestProperties(this._queryExecutor, hostRef, new String[]{STORAGE_DEVICE_INFO_PROPERTY, ISCSI_MANAGER_SUPPORTED});
        if (properties.isEmpty()) {
            _logger.error((Object)String.format("Cannot fetch '[%s, %s]' for '%s'.", STORAGE_DEVICE_INFO_PROPERTY, ISCSI_MANAGER_SUPPORTED, hostRef));
            return result;
        }
        result.iscsiManagerSupported = (Boolean)properties.get(ISCSI_MANAGER_SUPPORTED);
        StorageDeviceInfo storageDeviceInfo = (StorageDeviceInfo)properties.get(STORAGE_DEVICE_INFO_PROPERTY);
        if (storageDeviceInfo == null) {
            _logger.error((Object)String.format("Cannot fetch '%s' for '%s'", STORAGE_DEVICE_INFO_PROPERTY, hostRef));
            return result;
        }
        result.isIScsiEnabledOnHost = storageDeviceInfo.softwareInternetScsiEnabled;
        if (storageDeviceInfo.hostBusAdapter == null) {
            return result;
        }
        StorageAdapterTopologyCountData[] adaptersCountData = StorageUtil.getStorageAdapterTopologyCountData((StorageDeviceInfo)storageDeviceInfo);
        result.adapters = this.buildAdapters(storageDeviceInfo.hostBusAdapter, adaptersCountData);
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="hostStorageAdapterPaths")
    public HostStorageAdapterPathsData[] getHostStorageAdapterPaths(ManagedObjectReference hostRef, String adapterKey) throws Exception {
        if (hostRef == null) {
            _logger.error((Object)"Host is null");
            return new HostStorageAdapterPathsData[0];
        }
        Map<String, Object> properties = com.vmware.vsphere.client.h5.storage.util.StorageUtil.requestProperties(this._queryExecutor, hostRef, new String[]{STORAGE_DEVICE_INFO_PROPERTY, STORAGE_MULTIPATH_INFO_PROPERTY});
        if (properties.isEmpty()) {
            _logger.error((Object)String.format("Cannot fetch '[%s, %s]' for '%s'", STORAGE_DEVICE_INFO_PROPERTY, STORAGE_MULTIPATH_INFO_PROPERTY, hostRef));
            return new HostStorageAdapterPathsData[0];
        }
        StorageDeviceInfo sdi = (StorageDeviceInfo)properties.get(STORAGE_DEVICE_INFO_PROPERTY);
        if (sdi == null) {
            _logger.error((Object)("StorageDeviceInfo for host [" + hostRef + "] is null"));
            return new HostStorageAdapterPathsData[0];
        }
        MultipathStateInfo msi = (MultipathStateInfo)properties.get(STORAGE_MULTIPATH_INFO_PROPERTY);
        if (msi == null) {
            _logger.error((Object)("MultipathStateInfo for host [" + hostRef + "] is null"));
            return new HostStorageAdapterPathsData[0];
        }
        HostStoragePropertyCache cache = new HostStoragePropertyCache(sdi, msi);
        PlugStoreTopology.Adapter pstAdapter = cache.getPstAdapterFromHbaKey(adapterKey);
        if (pstAdapter == null) {
            _logger.error((Object)("Invalid adapterKey passed:[" + adapterKey + "]"));
            String[] params = new String[]{adapterKey};
            throw new IllegalArgumentException(StorageUtil.getLocalizedString((String)"error.invalidAdapter", (String[])params));
        }
        PlugStoreTopology.Plugin[] pstPluginsArray = cache.pstPlugins.values().toArray(new PlugStoreTopology.Plugin[cache.pstPlugins.size()]);
        ArrayList<HostStorageAdapterPathsData> dtos = new ArrayList<HostStorageAdapterPathsData>();
        if (!ArrayUtil.isNullOrEmpty((Object[])pstAdapter.path)) {
            for (String pathKey : pstAdapter.path) {
                if (StorageUtil.isPathMasked((String)pathKey, (PlugStoreTopology.Plugin[])pstPluginsArray)) continue;
                StoragePathData storagePathData = StorageUtil.buildStoragePathData((String)pathKey, (HostStoragePropertyCache)cache);
                dtos.add(HostStorageAdaptersPropertyProvider.buildHostStorageAdapterPathsData(storagePathData));
            }
        }
        return dtos.toArray(new HostStorageAdapterPathsData[dtos.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="fcoeConfig")
    public FcoeConfigData getFcoeConfig(ManagedObjectReference hostRef, String fcoePnicName) throws Exception {
        PhysicalNic[] physicalNics;
        FcoeConfigData result = new FcoeConfigData();
        Map<String, Object> hostPnicResponse = com.vmware.vsphere.client.h5.storage.util.StorageUtil.requestProperties(this._queryExecutor, hostRef, new String[]{HOST_PNIC_PROPERTY});
        if (hostPnicResponse.get(HOST_PNIC_PROPERTY) == null) {
            _logger.error((Object)String.format("Cannot fetch '%s' for '%s'", HOST_PNIC_PROPERTY, hostRef));
            return result;
        }
        for (PhysicalNic currentNic : physicalNics = (PhysicalNic[])hostPnicResponse.get(HOST_PNIC_PROPERTY)) {
            if (!currentNic.device.equals(fcoePnicName) || currentNic.fcoeConfiguration == null) continue;
            result.priorityClass = currentNic.fcoeConfiguration.priorityClass;
            break;
        }
        return result;
    }

    private StorageAdapterData[] buildAdapters(HostBusAdapter[] hostBusAdapters, StorageAdapterTopologyCountData[] adaptersCountData) {
        StorageAdapterData[] adapters = new StorageAdapterData[hostBusAdapters.length];
        HashMap<String, StorageAdapterTopologyCountData> adaptersCountsByKey = new HashMap<String, StorageAdapterTopologyCountData>();
        if (adaptersCountData != null) {
            for (StorageAdapterTopologyCountData countData : adaptersCountData) {
                adaptersCountsByKey.put(countData.adapterKey, countData);
            }
        }
        for (int i = 0; i < hostBusAdapters.length; ++i) {
            adapters[i] = this.createAdapterData(hostBusAdapters[i]);
            StorageAdapterTopologyCountData countData = (StorageAdapterTopologyCountData)adaptersCountsByKey.get(adapters[i].key);
            if (countData == null) continue;
            adapters[i].numberOfTargets = countData.numberOfTargets;
            adapters[i].numberOfDevices = countData.numberOfDevices;
            adapters[i].numberOfPaths = countData.numberOfPaths;
        }
        return adapters;
    }

    private StorageAdapterData createAdapterData(HostBusAdapter hba) {
        StorageAdapterData result;
        StorageAdapterType adapterType = StorageAdapterType.getType((HostBusAdapter)hba);
        if (StorageAdapterType.ISCSI.equals((Object)adapterType)) {
            IscsiStorageAdapterData iscsiStorageAdapterData = new IscsiStorageAdapterData();
            InternetScsiHba iscsiHba = (InternetScsiHba)hba;
            iscsiStorageAdapterData.isSoftwareBased = iscsiHba.isSoftwareBased;
            iscsiStorageAdapterData.canBeDisabled = iscsiHba.canBeDisabled;
            iscsiStorageAdapterData.iScsiName = iscsiHba.iScsiName;
            iscsiStorageAdapterData.iScsiAlias = iscsiHba.iScsiAlias;
            iscsiStorageAdapterData.formattedDiscoveryProperties = this.formatIscsiDiscoveryProperties(iscsiHba);
            if (iscsiHba.ipProperties != null) {
                iscsiStorageAdapterData.macAddress = iscsiHba.ipProperties.mac;
            }
            iscsiStorageAdapterData.currentSpeedInMbit = iscsiHba.currentSpeedMb;
            iscsiStorageAdapterData.maxSpeedInMbit = iscsiHba.maxSpeedMb;
            result = iscsiStorageAdapterData;
        } else if (hba instanceof FibreChannelHba) {
            FibreChannelStorageAdapterData fcAdapterData;
            if (StorageAdapterType.FCOE.equals((Object)adapterType)) {
                FibreChannelOverEthernetStorageAdapterData fcoeAdapterData = new FibreChannelOverEthernetStorageAdapterData();
                FibreChannelOverEthernetHba fcoeHba = (FibreChannelOverEthernetHba)hba;
                fcoeAdapterData.isMarkedForRemoval = fcoeHba.markedForRemoval;
                fcoeAdapterData.underlyingNic = fcoeHba.underlyingNic;
                fcoeAdapterData.linkInfo = fcoeHba.linkInfo;
                fcAdapterData = fcoeAdapterData;
            } else {
                fcAdapterData = new FibreChannelStorageAdapterData();
            }
            FibreChannelHba fcHba = (FibreChannelHba)hba;
            fcAdapterData.formattedNodeWorldWideName = HostStorageAdaptersPropertyProvider.formatWorldWidePortName(fcHba.nodeWorldWideName);
            fcAdapterData.formattedPortWorldWideName = HostStorageAdaptersPropertyProvider.formatWorldWidePortName(fcHba.portWorldWideName);
            result = fcAdapterData;
        } else {
            result = new StorageAdapterData();
        }
        result.key = hba.key;
        result.device = hba.device;
        result.status = hba.status;
        result.model = hba.model;
        result.type = adapterType;
        result.identifier = HostStorageAdaptersPropertyProvider.formatIdentifier(hba);
        return result;
    }

    private String formatIscsiDiscoveryProperties(InternetScsiHba iscsiHba) {
        InternetScsiHba.DiscoveryProperties discProps = iscsiHba.discoveryProperties;
        String result = "";
        if (discProps == null) {
            return StorageStringUtil.getString("storage.adapters.iscsiTargets.discovery.none");
        }
        if (discProps.iSnsDiscoveryEnabled) {
            result = result + StorageStringUtil.getString("storage.adapters.iscsiTargets.discovery.isns") + COMMA_SEPARATOR;
        }
        if (discProps.sendTargetsDiscoveryEnabled) {
            result = result + StorageStringUtil.getString("storage.adapters.iscsiTargets.discovery.sendTargets") + COMMA_SEPARATOR;
        }
        if (discProps.slpDiscoveryEnabled) {
            result = result + StorageStringUtil.getString("storage.adapters.iscsiTargets.discovery.slp") + COMMA_SEPARATOR;
        }
        if (discProps.staticTargetDiscoveryEnabled) {
            result = result + StorageStringUtil.getString("storage.adapters.iscsiTargets.discovery.staticTargets") + COMMA_SEPARATOR;
        }
        if (result.length() == 0) {
            return StorageStringUtil.getString("storage.adapters.iscsiTargets.discovery.none");
        }
        if (result.lastIndexOf(COMMA_SEPARATOR) == result.length() - COMMA_SEPARATOR.length()) {
            result = result.substring(0, result.length() - COMMA_SEPARATOR.length());
        }
        return result;
    }

    private static String formatIdentifier(HostBusAdapter hba) {
        if (hba instanceof FibreChannelHba) {
            FibreChannelHba fibreChannelHba = (FibreChannelHba)hba;
            String nodeName = HostStorageAdaptersPropertyProvider.formatWorldWidePortName(fibreChannelHba.nodeWorldWideName);
            String portName = HostStorageAdaptersPropertyProvider.formatWorldWidePortName(fibreChannelHba.portWorldWideName);
            if (nodeName.isEmpty()) {
                return portName;
            }
            if (portName.isEmpty()) {
                return nodeName;
            }
            return nodeName + " " + portName;
        }
        if (hba instanceof InternetScsiHba) {
            InternetScsiHba iscsiHba = (InternetScsiHba)hba;
            String result = StringUtil.isNullOrEmpty((String)iscsiHba.iScsiAlias) ? iscsiHba.iScsiName : (StringUtil.isNullOrEmpty((String)iscsiHba.iScsiName) ? iscsiHba.iScsiAlias : String.format("%s(%s)", iscsiHba.iScsiAlias, iscsiHba.iScsiName));
            if (result == null) {
                result = StorageStringUtil.getString("na");
            }
            return result;
        }
        return StorageStringUtil.getString("na");
    }

    private static String formatWorldWidePortName(long port) {
        if (port == 0L) {
            return "";
        }
        StringBuilder result = new StringBuilder(Long.toHexString(port));
        if (result.length() % 2 != 0) {
            result.insert(0, '0');
        }
        for (int i = result.length() - 2; i >= 2; i -= 2) {
            result.insert(i, ':');
        }
        return result.toString();
    }

    private static HostStorageAdapterPathsData buildHostStorageAdapterPathsData(StoragePathData data) {
        HostStorageAdapterPathsData pathData = new HostStorageAdapterPathsData();
        if (data.pathLun != null) {
            if (data.pathLun.displayName != null) {
                pathData.device = data.pathLun.displayName;
            }
            if (data.pathLun.canonicalName != null) {
                pathData.lunId = data.pathLun.canonicalName;
            }
        }
        pathData.runtimeName = com.vmware.vsphere.client.h5.storage.util.StorageUtil.formatPathRuntimeName(data);
        pathData.lunNumber = -1;
        if (data.path != null && data.path.lunNumber != null) {
            pathData.lunNumber = data.path.lunNumber;
        }
        pathData.pathState = data.pathState;
        pathData.isWorkingPath = data.isWorkingPath;
        if (data.pathTarget != null) {
            pathData.formattedTarget = com.vmware.vsphere.client.h5.storage.util.StorageUtil.formatTargetStringForPath(data.pathTarget.transport);
        } else {
            _logger.error((Object)("HostStorageAdapterPath " + data.path + " pathTarget is null"));
            pathData.formattedTarget = "";
        }
        return pathData;
    }
}

