/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.util.StringUtil;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.h5.storage.data.devices.HostStorageDevicePathsData;
import com.vmware.vsphere.client.h5.storage.data.devices.StorageDeviceItemData;
import com.vmware.vsphere.client.h5.storage.data.wizard.DatastoreStorageDevice;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import com.vmware.vsphere.client.h5.storage.util.StorageUtil;
import com.vmware.vsphere.client.storage.DeviceMultipathingInfo;
import com.vmware.vsphere.client.storage.ScsiDiskInfo;
import com.vmware.vsphere.client.storage.adapters.StorageDeviceData;
import com.vmware.vsphere.client.storage.adapters.StorageDeviceTransport;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostStorageDevicesPropertyProvider
implements PropertyProviderBean {
    private static final String STORAGE_DEVICES_PROPERTY = "storageAdapterDevices";
    private static final String DATASTORE_CONNECTED_HOST = "connectedHost";
    private static final String AVAILABLE_DISK_FOR_VMFS = "availableDisksForVmfs";
    private static Log _logger = LogFactory.getLog(HostStorageDevicesPropertyProvider.class);
    private static final String STORAGE_DEVICE_PATHS_PROPERTY = "deviceMultipathingInfo";
    private static final String FIXED_PATH = "VMW_PSP_FIXED";
    private static final String LEGACY_FIXED_PATH = "fixed";
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;

    public HostStorageDevicesPropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStorageDevices")
    public StorageDeviceItemData[] getHostStorageDevices(ManagedObjectReference hostRef, String adapterKey) throws Exception {
        StorageDeviceData[] storageDevices;
        ArrayList<StorageDeviceItemData> result = new ArrayList<StorageDeviceItemData>();
        if (adapterKey == null) {
            storageDevices = (StorageDeviceData[])this._queryExecutor.getProperty((Object)hostRef, STORAGE_DEVICES_PROPERTY);
        } else {
            HashMap<String, Object> propertyParams = new HashMap<String, Object>();
            propertyParams.put(STORAGE_DEVICES_PROPERTY, adapterKey);
            Map<String, Object> devicesForSingleAdapter = StorageUtil.requestPropertiesWithParams(this._queryExecutor, this._querySpecBuilder, hostRef, new String[]{STORAGE_DEVICES_PROPERTY}, propertyParams);
            if (devicesForSingleAdapter.get(STORAGE_DEVICES_PROPERTY) == null) {
                return result.toArray(new StorageDeviceItemData[result.size()]);
            }
            storageDevices = (StorageDeviceData[])devicesForSingleAdapter.get(STORAGE_DEVICES_PROPERTY);
        }
        if (storageDevices != null) {
            for (StorageDeviceData storageDeviceData : storageDevices) {
                if (storageDeviceData == null || storageDeviceData.underlyingLun == null) continue;
                result.add(HostStorageDevicesPropertyProvider.buildStorageDevice(storageDeviceData));
            }
        }
        return result.toArray(new StorageDeviceItemData[result.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStorageDevicePaths")
    public HostStorageDevicePathsData[] getHostStorageDevicePaths(ManagedObjectReference hostRef, String deviceName) throws Exception {
        if (hostRef == null) {
            _logger.error((Object)"Host is null");
            return new HostStorageDevicePathsData[0];
        }
        HashMap<String, Object> propertyParams = new HashMap<String, Object>();
        propertyParams.put(STORAGE_DEVICE_PATHS_PROPERTY, deviceName);
        Map<String, Object> pathsForSingleDevice = StorageUtil.requestPropertiesWithParams(this._queryExecutor, this._querySpecBuilder, hostRef, new String[]{STORAGE_DEVICE_PATHS_PROPERTY}, propertyParams);
        Object result = pathsForSingleDevice.get(STORAGE_DEVICE_PATHS_PROPERTY);
        if (result == null) {
            return new HostStorageDevicePathsData[0];
        }
        DeviceMultipathingInfo deviceInfo = (DeviceMultipathingInfo)result;
        Object[] paths = deviceInfo.paths;
        if (ArrayUtil.isNullOrEmpty((Object[])paths)) {
            return new HostStorageDevicePathsData[0];
        }
        ArrayList<HostStorageDevicePathsData> pathsData = new ArrayList<HostStorageDevicePathsData>();
        String preferredPath = null;
        if (deviceInfo.pathSelectionPolicy != null) {
            preferredPath = HostStorageDevicesPropertyProvider.getPreferredPathName(deviceInfo.pathSelectionPolicy);
        }
        for (Object path : paths) {
            pathsData.add(this.buildHostStorageDevicePathsData((StoragePathData)path, preferredPath));
        }
        return pathsData.toArray(new HostStorageDevicePathsData[pathsData.size()]);
    }

    private HostStorageDevicePathsData buildHostStorageDevicePathsData(StoragePathData data, String preferredPath) {
        HostStorageDevicePathsData pathData = new HostStorageDevicePathsData();
        pathData.runtimeName = StorageUtil.formatPathRuntimeName(data);
        pathData.pathState = data.pathState;
        pathData.isWorkingPath = data.isWorkingPath;
        if (data.pathTarget != null) {
            pathData.formattedTarget = StorageUtil.formatTargetStringForPath(data.pathTarget.transport);
        } else {
            _logger.error((Object)("HostStorageDevicePath " + data.path + " pathTarget is null"));
            pathData.formattedTarget = "";
        }
        pathData.name = data.path.name;
        pathData.preferred = "";
        if (pathData.name.equals(preferredPath)) {
            pathData.preferred = StorageStringUtil.getString("storage.paths.preferredString");
        }
        return pathData;
    }

    private static String getPreferredPathName(MultipathInfo.LogicalUnitPolicy policy) {
        if (policy instanceof MultipathInfo.FixedLogicalUnitPolicy) {
            MultipathInfo.FixedLogicalUnitPolicy fixedLogicalPolicy = (MultipathInfo.FixedLogicalUnitPolicy)policy;
            if (HostStorageDevicesPropertyProvider.isFixedPolicy(fixedLogicalPolicy.policy)) {
                return fixedLogicalPolicy.prefer;
            }
        }
        return StorageStringUtil.getString("storage.paths.na");
    }

    private static boolean isFixedPolicy(String policyKey) {
        return policyKey.equals(FIXED_PATH) || policyKey.equals(LEGACY_FIXED_PATH);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="storagedevice", property="datastoreStorageDevices")
    public DatastoreStorageDevice getDatastoreStorageDevices(ManagedObjectReference datastoreRef) throws Exception {
        DatastoreStorageDevice result = new DatastoreStorageDevice();
        ManagedObjectReference connectedHost = (ManagedObjectReference)this._queryExecutor.getProperty((Object)datastoreRef, DATASTORE_CONNECTED_HOST);
        if (connectedHost == null) {
            _logger.error((Object)String.format("Connected host for datastore %s is null.", datastoreRef));
            return result;
        }
        result.connectedHost = connectedHost;
        HashMap<String, Object> propertyParams = new HashMap<String, Object>();
        propertyParams.put(AVAILABLE_DISK_FOR_VMFS, datastoreRef);
        Map<String, Object> devicesForSingleAdapter = StorageUtil.requestPropertiesWithParams(this._queryExecutor, this._querySpecBuilder, connectedHost, new String[]{AVAILABLE_DISK_FOR_VMFS}, propertyParams);
        result.scsiDiskInfos = (ScsiDiskInfo[])devicesForSingleAdapter.get(AVAILABLE_DISK_FOR_VMFS);
        return result;
    }

    private static StorageDeviceItemData buildStorageDevice(StorageDeviceData deviceData) {
        StorageDeviceItemData itemData = new StorageDeviceItemData();
        ScsiLun lun = deviceData.underlyingLun;
        itemData.name = HostStorageDevicesPropertyProvider.getScsiLunName(lun);
        itemData.identifier = StorageStringUtil.getEmptyIfNull(lun.canonicalName);
        itemData.lunUuid = StorageStringUtil.getEmptyIfNull(lun.uuid);
        itemData.lunNumber = deviceData.lunNumber;
        itemData.type = lun.deviceType;
        itemData.isScsiDisk = lun instanceof ScsiDisk;
        itemData.hardwareAcceleration = HostStorageDevicesPropertyProvider.getHardwareAcceleration(lun);
        itemData.operationalState = HostStorageDevicesPropertyProvider.getOperationalState(lun.operationalState);
        itemData.ownerPlugin = deviceData.ownerPlugin;
        itemData.adapter = deviceData.adapter;
        itemData.transport = HostStorageDevicesPropertyProvider.getTransport(deviceData.transport);
        itemData.physicalLocation = HostStorageDevicesPropertyProvider.getPhysicalLocation(lun);
        itemData.devicePath = HostStorageDevicesPropertyProvider.getDevicePath(lun);
        itemData.isFlash = HostStorageDevicesPropertyProvider.isFlashDevice(lun);
        itemData.capacity = HostStorageDevicesPropertyProvider.getCapacity(lun);
        itemData.sectorFormat = HostStorageDevicesPropertyProvider.getSectorFormat(lun);
        return itemData;
    }

    private static String getScsiLunName(ScsiLun scsiLun) {
        if (!com.vmware.vise.util.StringUtil.isNullOrEmpty((String)scsiLun.displayName)) {
            return scsiLun.displayName;
        }
        return StorageStringUtil.getEmptyIfNull(scsiLun.canonicalName);
    }

    private static String[] getPhysicalLocation(ScsiLun scsiLun) {
        if (scsiLun instanceof ScsiDisk) {
            return ((ScsiDisk)scsiLun).physicalLocation;
        }
        return new String[0];
    }

    private static String getDevicePath(ScsiLun scsiLun) {
        if (scsiLun instanceof ScsiDisk) {
            return ((ScsiDisk)scsiLun).devicePath;
        }
        return "";
    }

    private static boolean isFlashDevice(ScsiLun scsiLun) {
        Boolean ssd;
        if (scsiLun instanceof ScsiDisk && (ssd = ((ScsiDisk)scsiLun).ssd) != null) {
            return ssd;
        }
        return false;
    }

    private static long getCapacity(ScsiLun scsiLun) {
        if (scsiLun instanceof ScsiDisk) {
            return StorageUtil.lbaToBytes(((ScsiDisk)scsiLun).capacity);
        }
        return 0L;
    }

    private static String getSectorFormat(ScsiLun scsiLun) {
        String scsiDiskType;
        if (scsiLun instanceof ScsiDisk && (scsiDiskType = ((ScsiDisk)scsiLun).scsiDiskType) != null) {
            String diskTypeKey = "scsiDisk.scsiDiskType.unknown";
            switch (ScsiDisk.ScsiDiskType.valueOf((String)scsiDiskType)) {
                case native512: {
                    diskTypeKey = "scsiDisk.scsiDiskType.native512";
                    break;
                }
                case emulated512: {
                    diskTypeKey = "scsiDisk.scsiDiskType.emulated512";
                    break;
                }
                case native4k: {
                    diskTypeKey = "scsiDisk.scsiDiskType.native4k";
                }
            }
            return StorageStringUtil.getString(diskTypeKey);
        }
        return "";
    }

    private static String getTransport(StorageDeviceTransport[] transport) {
        if (transport != null && transport.length > 0) {
            Object[] localizedTransport = new String[transport.length];
            for (int i = 0; i < localizedTransport.length; ++i) {
                localizedTransport[i] = StorageStringUtil.getString("storage.adapters.devices.transport." + transport[i]);
            }
            return StringUtil.join((Object[])localizedTransport, (String)", ");
        }
        return StorageStringUtil.getString("storage.adapters.devices.transport.UnknownTransport");
    }

    private static ScsiLun.State getOperationalState(String[] operationalState) {
        if (operationalState != null) {
            HashSet<ScsiLun.State> operationalStateSet = new HashSet<ScsiLun.State>();
            for (String state : operationalState) {
                operationalStateSet.add(ScsiLun.State.valueOf((String)state));
            }
            if (operationalStateSet.contains(ScsiLun.State.ok)) {
                return ScsiLun.State.ok;
            }
            if (operationalStateSet.contains(ScsiLun.State.off)) {
                return ScsiLun.State.off;
            }
            if (operationalStateSet.contains(ScsiLun.State.lostCommunication)) {
                return ScsiLun.State.lostCommunication;
            }
            if (operationalStateSet.contains(ScsiLun.State.error)) {
                return ScsiLun.State.error;
            }
        }
        return ScsiLun.State.unknownState;
    }

    private static String getHardwareAcceleration(ScsiLun scsiLun) {
        ScsiLun.VStorageSupportStatus vStorageSupportStatus = ScsiLun.VStorageSupportStatus.vStorageUnknown;
        if (scsiLun.vStorageSupport != null) {
            vStorageSupportStatus = ScsiLun.VStorageSupportStatus.valueOf((String)scsiLun.vStorageSupport);
        }
        return StorageStringUtil.getString("vStorage." + vStorageSupportStatus.toString());
    }
}

