/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.h5.storage.util.StorageUtil;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageActionResolverPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(StorageActionResolverPropertyProvider.class);
    private static final String RUNTIME_CONNECTION_STATE = "runtime.connectionState";
    private static final String GRANTED_PRIVILEGES_PROP = "grantedPrivileges";
    private static final String HOST_MOUNT = "hostMount";
    private static final String[] HOST_CONFIG_STORAGE_PRIV = new String[]{"Host.Config.Storage"};
    private QueryExecutor _queryExecutor;

    public StorageActionResolverPropertyProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @type(value="Datacenter,ClusterComputeResource,HostSystem,Folder")
    public boolean getIsCreateDatastoreActionAvailable(ManagedObjectReference moRef) throws Exception {
        if (!ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, HostSystem.class)) {
            return true;
        }
        Map<String, Object> hostProperties = StorageUtil.requestProperties(this._queryExecutor, moRef, new String[]{RUNTIME_CONNECTION_STATE, GRANTED_PRIVILEGES_PROP});
        if (!hostProperties.containsKey(RUNTIME_CONNECTION_STATE) || !hostProperties.containsKey(GRANTED_PRIVILEGES_PROP)) {
            _logger.error((Object)"Failed to retrieve host properties.");
            return true;
        }
        HostSystem.ConnectionState connectionState = (HostSystem.ConnectionState)hostProperties.get(RUNTIME_CONNECTION_STATE);
        boolean isConnected = connectionState == HostSystem.ConnectionState.connected;
        boolean hasPrivileges = AuthorizationUtil.isPrivilegeGranted((String[])HOST_CONFIG_STORAGE_PRIV, (String[])((String[])hostProperties.get(GRANTED_PRIVILEGES_PROP)));
        return isConnected && hasPrivileges;
    }

    @type(value="Datastore")
    public boolean getIsDeleteDatastoreActionAvailable(ManagedObjectReference moRef) throws Exception {
        Map<String, Object> hostProperties = StorageUtil.requestProperties(this._queryExecutor, moRef, new String[]{HOST_MOUNT});
        Object[] hostMounts = (Datastore.HostMount[])hostProperties.get(HOST_MOUNT);
        if (ArrayUtil.isNullOrEmpty((Object[])hostMounts)) {
            return false;
        }
        ManagedObjectReference[] connectedHostRefs = new ManagedObjectReference[hostMounts.length];
        for (int i = 0; i < connectedHostRefs.length; ++i) {
            connectedHostRefs[i] = ((Datastore.HostMount)hostMounts[i]).key;
        }
        return this.canDeleteDatastore(connectedHostRefs);
    }

    private boolean canDeleteDatastore(ManagedObjectReference[] hostRefs) throws Exception {
        Map<String, Object> result = StorageUtil.requestPropertiesForMultipleObjects(this._queryExecutor, hostRefs, new String[]{RUNTIME_CONNECTION_STATE, GRANTED_PRIVILEGES_PROP});
        Map connectionStates = (Map)result.get(RUNTIME_CONNECTION_STATE);
        Map permissions = (Map)result.get(GRANTED_PRIVILEGES_PROP);
        for (ManagedObjectReference hostRef : connectionStates.keySet()) {
            boolean hasPrivileges;
            HostSystem.ConnectionState state = (HostSystem.ConnectionState)connectionStates.get(hostRef);
            if (!state.equals((Object)HostSystem.ConnectionState.connected) || !(hasPrivileges = AuthorizationUtil.isPrivilegeGranted((String[])HOST_CONFIG_STORAGE_PRIV, (String[])((String[])permissions.get(hostRef))))) continue;
            return true;
        }
        return false;
    }
}

