/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.storage.data.host.HostData;
import com.vmware.vsphere.client.h5.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoragePropertyProvider
implements PropertyProviderBean {
    private static final String NAME_PROPERTY = "name";
    private static final String HOST_POWER_STATE_PROPERTY = "runtime.powerState";
    private static final String HOST_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;
    private static final Log _logger = LogFactory.getLog(StoragePropertyProvider.class);

    public StoragePropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @ModelMetadata(type={"Datacenter", "Folder", "ClusterComputeResource"}, propertyNamespace="storage", property="availableHostsForCreateDatastore")
    public HostData[] getAvailableHostsForCreateDatastore(ManagedObjectReference moRef) throws Exception {
        Constraint hostConstraint;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, Folder.class)) {
            Constraint dcForFolderConstraint = this._querySpecBuilder.createConstraintForRelationship((Object)moRef, "dc", Datacenter.class.getSimpleName());
            hostConstraint = this._querySpecBuilder.createRelationalConstraint("host", dcForFolderConstraint, Boolean.valueOf(true), HostSystem.class.getSimpleName());
        } else {
            hostConstraint = this._querySpecBuilder.createConstraintForRelationship((Object)moRef, "host", HostSystem.class.getSimpleName());
        }
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(hostConstraint, new String[]{NAME_PROPERTY, HOST_POWER_STATE_PROPERTY, HOST_CONNECTION_STATE_PROPERTY});
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        if (resultSet == null || resultSet.items == null) {
            return new HostData[0];
        }
        ArrayList<HostData> result = new ArrayList<HostData>();
        for (ResultItem item : resultSet.items) {
            Map<String, Object> hostProperties = StorageUtil.mapPropertyNamesToValues(item.properties);
            HostData hostData = HostData.newInstance((ManagedObjectReference)item.resourceObject, (String)hostProperties.get(NAME_PROPERTY), (HostSystem.ConnectionState)hostProperties.get(HOST_CONNECTION_STATE_PROPERTY), (HostSystem.PowerState)hostProperties.get(HOST_POWER_STATE_PROPERTY));
            result.add(hostData);
        }
        return result.toArray(new HostData[result.size()]);
    }
}

