/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceMeterData;
import com.vmware.vsphere.client.commonservice.util.Util;
import java.util.ArrayList;

@QueryBinding(value="Datastore")
public final class DatastoreSummaryData
extends BaseSummaryData
implements ResourceMeterData {
    @Property(value="Datastore/summary/capacity")
    private long capacity;
    @Property(value="Datastore/info/freeSpace")
    private long freeSpace;
    @Property(value="Datastore/info/url")
    private String location;
    @Property(value="Datastore/specificType/@formatted")
    private String dsType;
    @Property(value="Datastore/capability/storageIORMSupported")
    private boolean storageIORMSupported;
    @Property(value="Datastore/iormConfiguration")
    private StorageResourceManager.IORMConfigInfo iormConfiguration;

    public long getReservedCapacity() {
        return this.capacity - this.freeSpace;
    }

    public boolean isIormEnabled() {
        if (!this.storageIORMSupported || this.iormConfiguration == null) {
            return false;
        }
        return this.iormConfiguration.enabled;
    }

    public BaseSummaryData.LabelValue[] getSummaryItems() {
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("datastore.summary.properties.type", (Object)this.dsType), new BaseSummaryData.LabelValue("datastore.summary.properties.url", (Object)this.location)};
    }

    public ResourceMeterData.ResourceMeter[] getResourceMeters() {
        String freeStorage = FormatUtil.getStorageFormatted((Long)this.freeSpace, (long)1L, (long)-1L);
        String usedStorage = FormatUtil.getStorageFormatted((Long)this.getReservedCapacity(), (long)1L, (long)-1L);
        String capacityStorage = FormatUtil.getStorageFormatted((Long)this.capacity, (long)1L, (long)-1L);
        return new ResourceMeterData.ResourceMeter[]{new ResourceMeterData.ResourceMeter("StorageResourceDataItem.StorageLabel", freeStorage, usedStorage, capacityStorage, Util.getPercentageUsage((long)this.getReservedCapacity(), (long)this.capacity))};
    }

    public BaseSummaryData.Badge[] getBadges() {
        ArrayList<BaseSummaryData.Badge> result = new ArrayList<BaseSummaryData.Badge>();
        if (this.isIormEnabled()) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-iormEnabled", "datastore.summary.badges.iorm", false));
        }
        return result.toArray(new BaseSummaryData.Badge[result.size()]);
    }
}

