/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceMeterData;
import com.vmware.vsphere.client.commonservice.util.Util;
import java.util.ArrayList;

@QueryBinding(value="StoragePod")
public final class DsClusterSummaryData
extends BaseSummaryData
implements ResourceMeterData {
    @Property(value="StoragePod/podStorageDrsEntry/storageDrsConfig/podConfig/ioLoadBalanceEnabled")
    private boolean ioLoadBalanceEnabled;
    @Property(value="StoragePod/podStorageDrsEntry/storageDrsConfig/podConfig/enabled")
    private boolean drsEnabled;
    @Property(value="StoragePod/summary/capacity")
    private long capacity;
    @Property(value="StoragePod/summary/freeSpace")
    private long freeSpace;
    @Property(value="StoragePod/datastore/length")
    private int datastoresCount;
    @Property(value="StoragePod/type")
    private String type;
    @Property(value="StoragePod/virtualDiskCount")
    private long vmdksCount;
    @Property(value="StoragePod/snapshotCount")
    private long snapshotCount;

    private long getReservedCapacity() {
        return this.capacity - this.freeSpace;
    }

    public BaseSummaryData.LabelValue[] getSummaryItems() {
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("dscluster.datastoreCount", (Object)Integer.toString(this.datastoresCount)), new BaseSummaryData.LabelValue("dscluster.vmdksCount", (Object)Long.toString(this.vmdksCount)), new BaseSummaryData.LabelValue("dscluster.snapshotCount", (Object)Long.toString(this.snapshotCount)), new BaseSummaryData.LabelValue("dscluster.type", (Object)this.type)};
    }

    public ResourceMeterData.ResourceMeter[] getResourceMeters() {
        String freeStorage = FormatUtil.getStorageFormatted((Long)this.freeSpace, (long)1L, (long)-1L);
        String usedStorage = FormatUtil.getStorageFormatted((Long)this.getReservedCapacity(), (long)1L, (long)-1L);
        String capacityStorage = FormatUtil.getStorageFormatted((Long)this.capacity, (long)1L, (long)-1L);
        return new ResourceMeterData.ResourceMeter[]{new ResourceMeterData.ResourceMeter("StorageResourceDataItem.StorageLabel", freeStorage, usedStorage, capacityStorage, Util.getPercentageUsage((long)this.getReservedCapacity(), (long)this.capacity))};
    }

    public BaseSummaryData.Badge[] getBadges() {
        ArrayList<BaseSummaryData.Badge> result = new ArrayList<BaseSummaryData.Badge>();
        if (this.drsEnabled) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-distributedResourceScheduler24", "dscluster.summaryFeatures.DRS", false));
        }
        if (this.ioLoadBalanceEnabled) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-iormEnabled", "dscluster.summaryFeatures.ioLoadBalancing", false));
        }
        return result.toArray(new BaseSummaryData.Badge[result.size()]);
    }
}

