/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.util;

import com.vmware.vim.binding.vim.host.DiskDimensions;
import com.vmware.vim.binding.vim.host.FibreChannelTargetTransport;
import com.vmware.vim.binding.vim.host.InternetScsiTargetTransport;
import com.vmware.vim.binding.vim.host.TargetTransport;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.common.model.PropertyValueData;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StorageUtil {
    private static final long BLOCK_SIZE_DEFAULT = 512L;
    public static final String NFS3 = "NFS";
    public static final String NFS41 = "NFS41";
    private static final String VVOL = "vvol";
    private static final String VMFS = "vmfs";
    private static final String PATH_RUNTIME_NAME_TMPL = "%s:C%s:T%s:L%s";

    public static long lbaToBytes(DiskDimensions.Lba lba) {
        long blockSize = lba.blockSize == 0 ? 512L : (long)lba.blockSize;
        return lba.block * blockSize;
    }

    public static Map<String, Object> requestPropertiesWithParams(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, Object mor, String[] propertyNames, Map<String, Object> propertyParams) throws Exception {
        QuerySpec querySpec = querySpecBuilder.buildQuerySpec(mor, propertyNames);
        for (PropertySpec propertySpec : querySpec.resourceSpec.propertySpecs) {
            if (propertySpec.propertyNames == null) continue;
            ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
            for (String propertyName : propertySpec.propertyNames) {
                if (!propertyParams.containsKey(propertyName)) continue;
                ParameterSpec paramSpec = new ParameterSpec();
                paramSpec.propertyName = propertyName;
                paramSpec.parameter = propertyParams.get(propertyName);
                parameterSpecs.add(paramSpec);
            }
            propertySpec.parameters = parameterSpecs.toArray(new ParameterSpec[parameterSpecs.size()]);
        }
        ResultSet resultSet = queryExecutor.getData(querySpec);
        if (resultSet != null && resultSet.items != null && resultSet.items.length > 0) {
            return StorageUtil.mapPropertyNamesToValues(resultSet.items[0].properties);
        }
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> requestProperties(QueryExecutor queryExecutor, Object mor, String[] propertyNames) throws Exception {
        PropertyValue[] propertyValues = queryExecutor.getProperties(mor, propertyNames);
        return StorageUtil.mapPropertyNamesToValues(propertyValues);
    }

    public static Map<String, Object> requestPropertiesForMultipleObjects(QueryExecutor queryExecutor, Object[] objects, String[] propertyNames) throws Exception {
        PropertyValue[] propertyValues = queryExecutor.getProperties(objects, propertyNames);
        return StorageUtil.mapPropertyNamesToMultipleValues(propertyValues);
    }

    public static Map<String, Object> mapPropertyNamesToValues(PropertyValue[] propertyValues) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (propertyValues != null) {
            for (PropertyValue propValue : propertyValues) {
                result.put(propValue.propertyName, propValue.value);
            }
        }
        return result;
    }

    public static Map<String, Object> mapPropertyNamesToMultipleValues(PropertyValue[] propertyValues) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (propertyValues != null) {
            for (PropertyValue property : propertyValues) {
                if (!result.containsKey(property.propertyName)) {
                    result.put(property.propertyName, new HashMap());
                }
                Map resultsPerValue = (Map)result.get(property.propertyName);
                resultsPerValue.put((ManagedObjectReference)property.resourceObject, property.value);
            }
        }
        return result;
    }

    public static String formatFlash(Boolean isFlash) {
        if (isFlash != null && isFlash.booleanValue()) {
            return StorageStringUtil.getString("flash");
        }
        return StorageStringUtil.getString("hdd");
    }

    public static String formatDatastoreType(String dsType) {
        if (NFS41.equalsIgnoreCase(dsType)) {
            return StorageStringUtil.getString("datastore.nfs41");
        }
        if (NFS3.equalsIgnoreCase(dsType)) {
            return StorageStringUtil.getString("datastore.nfs3");
        }
        if (VVOL.equalsIgnoreCase(dsType)) {
            return StorageStringUtil.getString("datastore.vvol");
        }
        return dsType;
    }

    public static PropertyValueData newPropValueDataWithKey(String labelKey, String value) {
        return PropertyValueData.newInstance((String)StorageStringUtil.getString(labelKey), (String)value);
    }

    public static String formatSupportedValue(Boolean supported) {
        if (Boolean.TRUE.equals(supported)) {
            return StorageStringUtil.getString("supported");
        }
        return StorageStringUtil.getString("notSupported");
    }

    public static String formatEnabledValue(Boolean enabled) {
        if (Boolean.TRUE.equals(enabled)) {
            return StorageStringUtil.getString("enabled");
        }
        return StorageStringUtil.getString("disabled");
    }

    public static boolean isVmfsDsType(String dsType) {
        return VMFS.equalsIgnoreCase(dsType);
    }

    public static String formatPathRuntimeName(StoragePathData data) {
        if (data.pathHba != null && data.path != null && data.pathHba.device != null && data.path.channelNumber != null && data.path.targetNumber != null && data.path.lunNumber != null) {
            return String.format(PATH_RUNTIME_NAME_TMPL, data.pathHba.device, data.path.channelNumber, data.path.targetNumber, data.path.lunNumber);
        }
        return "";
    }

    public static String formatTargetStringForPath(TargetTransport transport) {
        String formatted = "";
        if (transport == null) {
            return formatted;
        }
        if (transport instanceof FibreChannelTargetTransport) {
            FibreChannelTargetTransport fibreTransport = (FibreChannelTargetTransport)transport;
            String nodeName = StorageUtil.formatWWPN(fibreTransport.getNodeWorldWideName());
            String portName = StorageUtil.formatWWPN(fibreTransport.getPortWorldWideName());
            if (StringUtil.isNullOrEmpty((String)nodeName) && StringUtil.isNullOrEmpty((String)portName)) {
                return formatted;
            }
            if (StringUtil.isNullOrEmpty((String)nodeName)) {
                return portName;
            }
            if (StringUtil.isNullOrEmpty((String)portName)) {
                return nodeName;
            }
            formatted = String.format("%s %s", nodeName, portName);
        } else if (transport instanceof InternetScsiTargetTransport) {
            InternetScsiTargetTransport iscsiTransport = (InternetScsiTargetTransport)transport;
            StringBuilder ipAddressesStringBuilder = new StringBuilder();
            String[] ipAddresses = iscsiTransport.address;
            for (int i = 0; i < ipAddresses.length; ++i) {
                String ipAddress = ipAddresses[i];
                ipAddressesStringBuilder.append(ipAddress);
                if (i >= ipAddresses.length - 1) continue;
                ipAddressesStringBuilder.append(", ");
            }
            String ipAddressesString = ipAddressesStringBuilder.toString();
            if (StringUtil.isNullOrEmpty((String)iscsiTransport.iScsiName) && StringUtil.isNullOrEmpty((String)ipAddressesString)) {
                return formatted;
            }
            String name = !StringUtil.isNullOrEmpty((String)iscsiTransport.iScsiName) ? iscsiTransport.iScsiName : StorageStringUtil.getString("storage.adapters.iscsi.noName");
            formatted = String.format("%s:%s", name, ipAddressesString);
        }
        return formatted;
    }

    private static String formatWWPN(long wwpn) {
        StringBuilder builder = new StringBuilder(Long.toString(wwpn, 16));
        if (builder.length() % 2 != 0) {
            builder.insert(0, "0");
        }
        for (int i = builder.length() - 2; i > 0; i -= 2) {
            builder.insert(i, ":");
        }
        return builder.toString();
    }
}

