/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder;

import com.vmware.vim.binding.vim.option.OptionDef;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.TypeNodeDescriptor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.advancedsettings.AdvancedSettingsUtil;
import com.vmware.vsphere.client.folder.VcServerSettingsBaseDataBuilder;
import com.vmware.vsphere.client.folder.VcServerSettingsInfo;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class VcServerSettingsMetadataBuilder
extends VcServerSettingsBaseDataBuilder<OptionDef> {
    private static final String RESOURCE_BUNDLE_NAME = "VCenterServerSettings";
    private OptionDef[] _options;
    private Boolean _allowEdit = false;

    public VcServerSettingsMetadataBuilder(FeatureStateService featureStateService, OptionDef[] options) {
        super(featureStateService);
        this._options = options;
    }

    public VcServerSettingsMetadataBuilder(FeatureStateService featureStateService, OptionDef[] options, Boolean allowEdit) {
        super(featureStateService);
        this._options = options;
        this._allowEdit = allowEdit;
    }

    public TypeNodeDescriptor buildMetadata() {
        if (ArrayUtil.isNullOrEmpty((Object[])this._options)) {
            return null;
        }
        Map<String, String> typeUidBySectionsMap = this._featureStateService.isEnabled(Feature.VCDB_UI) ? VcServerSettingsInfo.TYPE_UID_BY_SECTIONS_VCDB_UI_ENABLED : VcServerSettingsInfo.TYPE_UID_BY_SECTIONS_VCDB_UI_DISABLED;
        TypeNodeDescriptor rootTypeDesc = new TypeNodeDescriptor();
        int sectionsCount = typeUidBySectionsMap.keySet().size();
        rootTypeDesc.properties = new PropertyNodeDescriptor[sectionsCount];
        int sectionIndex = 0;
        for (String sectionKey : typeUidBySectionsMap.keySet()) {
            TypeNodeDescriptor typeDesc = this.buildSectionMetadata(sectionKey);
            PropertyNodeDescriptor propDesc = new PropertyNodeDescriptor();
            propDesc.valueType = typeDesc;
            propDesc.name = sectionKey;
            propDesc.valueTypeName = typeUidBySectionsMap.get(sectionKey);
            propDesc.title = this.getLocalizedString("vcServerSettings." + sectionKey);
            rootTypeDesc.properties[sectionIndex] = propDesc;
            ++sectionIndex;
        }
        return rootTypeDesc;
    }

    public TypeNodeDescriptor buildSectionMetadata(String sectionKey) {
        if (ArrayUtil.isNullOrEmpty((Object[])this._options)) {
            return null;
        }
        TreeMap<String, OptionDef> optionsDefLookup = this.createSettingsLookup(this._options);
        String[] settingkeys = this.getSettingsKeysForSection(sectionKey, optionsDefLookup.keySet());
        ArrayList<OptionDef> options = new ArrayList<OptionDef>();
        for (String key : settingkeys) {
            options.add(optionsDefLookup.get(key));
        }
        TypeNodeDescriptor typeDesc = new TypeNodeDescriptor();
        boolean useKeyAsTitle = "advancedSettings".equals(sectionKey);
        typeDesc.properties = this.convertToMetadata(options.toArray(new OptionDef[0]), useKeyAsTitle);
        return typeDesc;
    }

    @Override
    protected String getSettingKey(OptionDef setting) {
        return setting.key;
    }

    private PropertyNodeDescriptor[] convertToMetadata(OptionDef[] optionDefs, boolean useKeyAsTitle) {
        ArrayList<PropertyNodeDescriptor> result = new ArrayList<PropertyNodeDescriptor>();
        for (OptionDef optionDef : optionDefs) {
            result.add(new PropertyNodeDescriptor(this.convertToPropertyDescriptor(optionDef, useKeyAsTitle)));
        }
        return result.toArray(new PropertyNodeDescriptor[0]);
    }

    private PropertyDescriptor convertToPropertyDescriptor(OptionDef optionDef, boolean useKeyAsTitle) {
        PropertyDescriptor propertyDescriptor = AdvancedSettingsUtil.createMetadataFromOptionDef((OptionDef)optionDef, (boolean)this._allowEdit, (boolean)useKeyAsTitle);
        if (!useKeyAsTitle) {
            propertyDescriptor.title = this.getLocalizedTitle(optionDef);
        }
        return propertyDescriptor;
    }

    private String getLocalizedTitle(OptionDef optionDef) {
        String localizedTitle = this.getLocalizedString(optionDef.key);
        if (localizedTitle == null || localizedTitle.equals("")) {
            localizedTitle = optionDef.label;
        }
        return localizedTitle;
    }

    private String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)this.getClass().getClassLoader());
    }
}

