/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.model.PredicateProperty;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryModel;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;

@QueryModel(value="Folder")
public class FolderExtendedDataModel {
    @Property(value="Folder/uiDisplayName")
    String name;
    @Property(value="Folder/isComputeResourceFolder")
    String isHostFolder;
    @Property(value="Folder/isDatastoreFolder")
    String isStorageFolder;
    @Property(value="Folder/isVirtualMachineFolder")
    String isVmFolder;
    @Relationship(value={"DistributedVirtualPortgroup/parent~"})
    @Property(value="DistributedVirtualPortgroup/@modelKey")
    ManagedObjectReference[] dvpg;
    @Relationship(value={"Datastore/parent~"})
    @Property(value="Datastore/@modelKey")
    ManagedObjectReference[] ds;
    @Relationship(value={"ClusterComputeResource/parent~"})
    @Property(value="ClusterComputeResource/@modelKey")
    ManagedObjectReference[] cluster;
    @Relationship(value={"VirtualMachine/parent~"})
    @Property(value="VirtualMachine/@modelKey")
    ManagedObjectReference[] childvm;
    @Relationship(value={"VirtualApp/parentFolder~"})
    @Property(value="VirtualApp/@modelKey")
    ManagedObjectReference[] childvapp;
    @Relationship(value={"Datacenter/parent~"})
    @Property(value="Datacenter/@modelKey")
    ManagedObjectReference[] childdc;
    @Relationship(value={"AnyDistributedVirtualSwitch/parent~"})
    @Property(value="AnyDistributedVirtualSwitch/@modelKey")
    ManagedObjectReference[] dvs;
    @Relationship(value={"AnyNetwork/parent~"})
    @Property(value="AnyNetwork/@modelKey")
    ManagedObjectReference[] nw;
    @Relationship(value={"ScheduledTask/info/taskObject~"})
    @Property(value="ScheduledTask/@modelKey")
    ManagedObjectReference[] scheduledTask;

    @PredicateProperty
    public static Filter getIsDatacenterOrRootFolder() {
        PropertyPredicate isDatacenterFolder = new PropertyPredicate("Folder/isDatacenterFolder", PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
        PropertyPredicate isRootFolder = new PropertyPredicate("Folder/isRootFolder", PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
        return new Filter(Arrays.asList(isDatacenterFolder, isRootFolder), LogicalOperator.OR);
    }

    @PredicateProperty
    public static Filter getIsNonrootHostFolder() {
        PropertyPredicate isNonRootFolderOfType = new PropertyPredicate("Folder/parentType", PropertyPredicate.ComparisonOperator.EQUAL, (Object)"Folder");
        PropertyPredicate isHostFolder = new PropertyPredicate("Folder/isComputeResourceFolder", PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
        return new Filter(Arrays.asList(isNonRootFolderOfType, isHostFolder), LogicalOperator.AND);
    }

    @PredicateProperty
    public static Filter getIsNonrootVmFolder() {
        PropertyPredicate isNonRootFolderOfType = new PropertyPredicate("Folder/parentType", PropertyPredicate.ComparisonOperator.EQUAL, (Object)"Folder");
        PropertyPredicate isVmFolder = new PropertyPredicate("Folder/isVirtualMachineFolder", PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
        return new Filter(Arrays.asList(isNonRootFolderOfType, isVmFolder), LogicalOperator.AND);
    }

    @PredicateProperty
    public static Filter getIsNonrootDatastoreFolder() {
        PropertyPredicate isNonRootFolder = new PropertyPredicate("Folder/parentType", PropertyPredicate.ComparisonOperator.EQUAL, (Object)"Folder");
        PropertyPredicate isDatastoreFolder = new PropertyPredicate("Folder/isDatastoreFolder", PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
        return new Filter(Arrays.asList(isNonRootFolder, isDatastoreFolder), LogicalOperator.AND);
    }

    @PredicateProperty
    public static Filter getIsNonrootNetworkFolder() {
        PropertyPredicate isNonRootFolder = new PropertyPredicate("Folder/parentType", PropertyPredicate.ComparisonOperator.EQUAL, (Object)"Folder");
        PropertyPredicate isNetworkFolder = new PropertyPredicate("Folder/isNetworkFolder", PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
        return new Filter(Arrays.asList(isNonRootFolder, isNetworkFolder), LogicalOperator.AND);
    }
}

