/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.metadata.metamodel;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.metadata.metamodel.EnumerationDefinitions;
import com.vmware.vapi.metadata.metamodel.EnumerationSyncProvider;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class EnumerationSyncApiInterface
extends ApiInterfaceSkeleton {
    private EnumerationSyncProvider impl;

    public EnumerationSyncApiInterface() {
        this((Class<? extends EnumerationSyncProvider>)null);
    }

    public EnumerationSyncApiInterface(Class<? extends EnumerationSyncProvider> implClass) {
        this((EnumerationSyncProvider)EnumerationSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.vapi.metadata.metamodel.impl.EnumerationImpl", EnumerationSyncProvider.class));
    }

    public EnumerationSyncApiInterface(EnumerationSyncProvider impl) {
        super("com.vmware.vapi.metadata.metamodel.enumeration");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(EnumerationSyncApiInterface.this.getIdentifier(), "get", EnumerationDefinitions.__getInput, EnumerationDefinitions.__getOutput, EnumerationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, EnumerationDefinitions.__getInput, EnumerationSyncApiInterface.this.getTypeConverter());
            String enumerationId = (String)extr.valueForField("enumeration_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)EnumerationSyncApiInterface.this.getTypeConverter().convertToVapi((Object)EnumerationSyncApiInterface.this.impl.get(enumerationId, invocationContext), EnumerationDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(EnumerationSyncApiInterface.this.getIdentifier(), "list", EnumerationDefinitions.__listInput, EnumerationDefinitions.__listOutput, EnumerationSyncApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(inStruct, EnumerationDefinitions.__listInput, EnumerationSyncApiInterface.this.getTypeConverter());
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)EnumerationSyncApiInterface.this.getTypeConverter().convertToVapi(EnumerationSyncApiInterface.this.impl.list(invocationContext), EnumerationDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

