/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.updates.impl;

import com.vmware.vise.core.model.Message;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.updates.ObjectUpdatesManager;
import com.vmware.vise.data.updates.impl.ObjectUpdatesManagerForAsyncOperations;
import com.vmware.vise.data.updates.impl.OperationResultEx;
import com.vmware.vise.data.updates.impl.UpdatesUtil;
import com.vmware.vise.data.updates.monitor.ObjectChangeMonitor;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.util.messaging.MessagingService;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectUpdatesManagerImpl
implements ObjectUpdatesManager {
    private static final Log _logger = LogFactory.getLog(ObjectUpdatesManagerImpl.class);
    private final ObjectUpdatesManagerForAsyncOperations _asyncOperationsUpdatesManager;
    private final ObjectReferenceService _objRefService;
    private final MessagingService _messagingService;
    private final Boolean isRiseEnabled;
    private ObjectChangeMonitor _monitor;

    public ObjectUpdatesManagerImpl(ObjectReferenceService objectReferenceService, MessagingService messagingService, ObjectUpdatesManagerForAsyncOperations objectUpdatesManagerForAsyncOperations, FeatureStateService featureStateService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService, messagingService, objectUpdatesManagerForAsyncOperations});
        this._objRefService = objectReferenceService;
        this._messagingService = messagingService;
        this._asyncOperationsUpdatesManager = objectUpdatesManagerForAsyncOperations;
        this.isRiseEnabled = featureStateService.isEnabled(Feature.RISE) && featureStateService.isEnabled(Feature.RISE_vSphere);
    }

    @Override
    public void sendUpdates(OperationResult[] operationResultArray, OperationType operationType) {
        OperationResultEx[] operationResultExArray = ObjectUpdatesManagerImpl.convertToOpResultExArray(operationResultArray, operationType);
        this.sendUpdates(operationResultExArray);
    }

    public ObjectChangeMonitor getMonitor() {
        return this._monitor;
    }

    public void setMonitor(ObjectChangeMonitor objectChangeMonitor) {
        this._monitor = objectChangeMonitor;
    }

    private void sendUpdates(OperationResultEx[] operationResultExArray) {
        if (operationResultExArray == null) {
            return;
        }
        Message message = new Message();
        message.type = "operationStarted";
        this._messagingService.sendMessage(message);
        ArrayList<OperationResultEx> arrayList = new ArrayList<OperationResultEx>();
        for (OperationResultEx operationResultEx : operationResultExArray) {
            if (operationResultEx != null && operationResultEx.operationResult != null && operationResultEx.operationResult.task != null) {
                String string = this.getTaskUid(operationResultEx);
                if (StringUtil.isNullOrEmpty((String)string)) continue;
                arrayList.add(operationResultEx);
                continue;
            }
            this.processSyncOperation(operationResultEx);
        }
        if (!arrayList.isEmpty()) {
            this._asyncOperationsUpdatesManager.sendUpdates(arrayList.toArray(new OperationResultEx[arrayList.size()]));
        }
    }

    void shutdown() {
        this._asyncOperationsUpdatesManager.shutdown();
    }

    private void processSyncOperation(OperationResultEx operationResultEx) {
        if (operationResultEx == null) {
            return;
        }
        if (!this.isRiseEnabled.booleanValue() && operationResultEx.operationType == OperationType.CHANGE) {
            UpdatesUtil.addToMonitor(operationResultEx, this._monitor);
            UpdatesUtil.removeFromMonitor(operationResultEx, this._monitor);
        } else {
            UpdatesUtil.sendObjectChangeUpdates(operationResultEx, this._objRefService, this._messagingService);
        }
    }

    private String getTaskUid(OperationResultEx operationResultEx) {
        if (StringUtil.isNullOrEmpty((String)operationResultEx.operationResult.taskUid)) {
            try {
                operationResultEx.operationResult.taskUid = this._objRefService.getUid(operationResultEx.operationResult.task);
            }
            catch (Exception exception) {
                _logger.error((Object)"Could not get the taskUid for the task", (Throwable)exception);
            }
        }
        return operationResultEx.operationResult.taskUid;
    }

    private static OperationResultEx[] convertToOpResultExArray(OperationResult[] operationResultArray, OperationType operationType) {
        OperationResultEx[] operationResultExArray = new OperationResultEx[operationResultArray.length];
        for (int i = 0; i < operationResultArray.length; ++i) {
            operationResultExArray[i] = new OperationResultEx(operationType, operationResultArray[i]);
        }
        return operationResultExArray;
    }
}

