/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.updates.impl;

import com.vmware.vise.core.model.Message;
import com.vmware.vise.core.model.ModelChangeMessage;
import com.vmware.vise.core.model.ObjectChangeInfo;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.updates.impl.OperationResultEx;
import com.vmware.vise.data.updates.monitor.ObjectChangeMonitor;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.messaging.MessagingService;

class UpdatesUtil {
    public static final String OPERATION_STARTED = "operationStarted";

    UpdatesUtil() {
    }

    static RequestSpec getQuerySpecForRecentTasks() {
        QuerySpec querySpec = UpdatesUtil.createRecentTasksSpec();
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[1];
        requestSpec.querySpec[0] = querySpec;
        return requestSpec;
    }

    static void sendObjectChangeUpdates(OperationResultEx operationResultEx, ObjectReferenceService objectReferenceService, MessagingService messagingService) {
        if (operationResultEx.taskInfo != null) {
            UpdatesUtil.processAsyncOperationUpdates(operationResultEx, objectReferenceService, messagingService);
        } else {
            UpdatesUtil.processSyncOperationUpdates(operationResultEx, objectReferenceService, messagingService);
        }
    }

    public static void addToMonitor(OperationResultEx operationResultEx, ObjectChangeMonitor objectChangeMonitor) {
        if (operationResultEx == null || objectChangeMonitor == null) {
            return;
        }
        objectChangeMonitor.add(operationResultEx.operationResult.entity);
        OperationEffect operationEffect = operationResultEx.operationResult.effect;
        if (operationEffect != null && operationEffect.affectedEntites != null) {
            Object[] objectArray;
            for (Object object : objectArray = operationEffect.affectedEntites) {
                objectChangeMonitor.add(object);
            }
        }
    }

    public static void removeFromMonitor(OperationResultEx operationResultEx, ObjectChangeMonitor objectChangeMonitor) {
        if (operationResultEx == null || objectChangeMonitor == null) {
            return;
        }
        OperationEffect operationEffect = operationResultEx.operationResult.effect;
        boolean bl = operationEffect != null && operationEffect.isDelayed;
        objectChangeMonitor.remove(operationResultEx.operationResult.entity, bl);
        if (operationEffect != null && operationEffect.affectedEntites != null) {
            Object[] objectArray;
            for (Object object : objectArray = operationEffect.affectedEntites) {
                objectChangeMonitor.remove(object, bl);
            }
        }
    }

    private static void processAsyncOperationUpdates(OperationResultEx operationResultEx, ObjectReferenceService objectReferenceService, MessagingService messagingService) {
        ClientTaskInfo clientTaskInfo = operationResultEx.taskInfo;
        if (clientTaskInfo.state != TaskState.SUCCESS) {
            return;
        }
        ObjectChangeInfo objectChangeInfo = new ObjectChangeInfo();
        objectChangeInfo.operationType = operationResultEx.operationType;
        if (operationResultEx.operationType == OperationType.ADD) {
            objectChangeInfo.objectId = UpdatesUtil.getResultEntityUidFromTaskInfo(clientTaskInfo, objectReferenceService);
            objectChangeInfo.object = clientTaskInfo.result;
        } else if (operationResultEx.operationType == OperationType.CHANGE || operationResultEx.operationType == OperationType.DELETE) {
            objectChangeInfo.objectId = UpdatesUtil.getEntityUidFromTaskInfo(clientTaskInfo, objectReferenceService);
            objectChangeInfo.object = clientTaskInfo.entity;
        }
        UpdatesUtil.sendModelChangedEvent(objectChangeInfo, messagingService);
    }

    private static String getResultEntityUidFromTaskInfo(ClientTaskInfo clientTaskInfo, ObjectReferenceService objectReferenceService) {
        String string = null;
        if (StringUtil.isNullOrEmpty((String)clientTaskInfo.resultEntityUid)) {
            if (clientTaskInfo.result != null) {
                string = objectReferenceService.getUid(clientTaskInfo.result, true);
            }
        } else {
            string = clientTaskInfo.resultEntityUid;
        }
        return string;
    }

    private static String getEntityUidFromTaskInfo(ClientTaskInfo clientTaskInfo, ObjectReferenceService objectReferenceService) {
        String string = null;
        if (StringUtil.isNullOrEmpty((String)clientTaskInfo.entityUid)) {
            if (clientTaskInfo.entity != null) {
                string = objectReferenceService.getUid(clientTaskInfo.entity, true);
            }
        } else {
            string = clientTaskInfo.entityUid;
        }
        return string;
    }

    private static void sendModelChangedEvent(ObjectChangeInfo objectChangeInfo, MessagingService messagingService) {
        if (objectChangeInfo == null || StringUtil.isNullOrEmpty((String)objectChangeInfo.objectId)) {
            return;
        }
        ModelChangeMessage modelChangeMessage = new ModelChangeMessage();
        modelChangeMessage.setObjectChangeInfo(objectChangeInfo);
        messagingService.sendMessage((Message)modelChangeMessage);
    }

    private static void processSyncOperationUpdates(OperationResultEx operationResultEx, ObjectReferenceService objectReferenceService, MessagingService messagingService) {
        if (operationResultEx.operationResult.error != null) {
            return;
        }
        ObjectChangeInfo objectChangeInfo = new ObjectChangeInfo();
        objectChangeInfo.operationType = operationResultEx.operationType;
        if (operationResultEx.operationType == OperationType.ADD) {
            Object object = operationResultEx.operationResult.result != null ? operationResultEx.operationResult.result : operationResultEx.operationResult.entity;
            objectChangeInfo.objectId = objectReferenceService.getUid(object, true);
            objectChangeInfo.object = object;
        } else if (operationResultEx.operationType == OperationType.CHANGE || operationResultEx.operationType == OperationType.DELETE) {
            objectChangeInfo.objectId = objectReferenceService.getUid(operationResultEx.operationResult.entity, true);
            objectChangeInfo.object = operationResultEx.operationResult.entity;
        }
        UpdatesUtil.sendModelChangedEvent(objectChangeInfo, messagingService);
    }

    private static QuerySpec createRecentTasksSpec() {
        Constraint constraint;
        QuerySpec querySpec = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        PropertySpec propertySpec = new PropertySpec();
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = -1;
        resourceSpec.constraint = constraint = UpdatesUtil.createRecentTaskSearchConstraint();
        propertySpec.propertyNames = new String[1];
        propertySpec.propertyNames[0] = "info";
        resourceSpec.propertySpecs = new PropertySpec[1];
        resourceSpec.propertySpecs[0] = propertySpec;
        querySpec.name = "vsphere:Task-info";
        querySpec.resourceSpec = resourceSpec;
        querySpec.resultSpec = resultSpec;
        return querySpec;
    }

    private static Constraint createRecentTaskSearchConstraint() {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.propertyName = "info.recentTasks";
        propertyConstraint.comparableValue = true;
        propertyConstraint.targetType = "vsphere:Task";
        propertyConstraint.comparator = Comparator.EQUALS;
        return propertyConstraint;
    }
}

