/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.updates.monitor.impl;

import com.vmware.vise.core.model.ObjectChangeInfo;
import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.updates.monitor.ObjectChangeService;
import com.vmware.vise.data.updates.monitor.impl.ObjectGeneration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenerationNumbersChangeService
implements ObjectChangeService {
    private final Map<String, ObjectGeneration> _generationCache = new HashMap<String, ObjectGeneration>();
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _queryBuilder;
    private final ObjectReferenceService _objRefService;

    public GenerationNumbersChangeService(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, ObjectReferenceService objectReferenceService) {
        this._queryExecutor = queryExecutor;
        this._queryBuilder = querySpecBuilder;
        this._objRefService = objectReferenceService;
    }

    @Override
    public List<ObjectChangeInfo> getChanges(List<Object> list) throws Exception {
        Object[] objectArray = list.toArray(new Object[list.size()]);
        QuerySpec querySpec = this._queryBuilder.buildQuerySpec(objectArray, new String[0]);
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        List<ObjectChangeInfo> list2 = this.computeChangesAndUpdateCache(resultSet);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ObjectChangeInfo> computeChangesAndUpdateCache(ResultSet resultSet) {
        ArrayList<ObjectChangeInfo> arrayList = new ArrayList<ObjectChangeInfo>();
        Map<String, ObjectGeneration> map = this._generationCache;
        synchronized (map) {
            for (ResultItem resultItem : resultSet.items) {
                String string = this.getUid(resultItem.resourceObject);
                ObjectGeneration objectGeneration = this._generationCache.containsKey(string) ? this._generationCache.get(string) : ObjectGeneration.UKNOWN;
                ObjectGeneration objectGeneration2 = ObjectGeneration.fromResultItem(resultItem);
                if (!objectGeneration2.isNewer(objectGeneration)) continue;
                this._generationCache.put(string, objectGeneration2);
                arrayList.add(this.createObjectChangeInfo(resultItem.resourceObject));
            }
        }
        return arrayList;
    }

    private ObjectChangeInfo createObjectChangeInfo(Object object) {
        ObjectChangeInfo objectChangeInfo = new ObjectChangeInfo();
        objectChangeInfo.operationType = OperationType.CHANGE;
        objectChangeInfo.object = object;
        objectChangeInfo.objectId = this.getUid(object);
        return objectChangeInfo;
    }

    private String getUid(Object object) {
        return this._objRefService.getUid(object, true);
    }
}

