/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.updates.monitor.impl;

import com.vmware.vise.data.query.ObjectReferenceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonitorRegistry {
    private static final long EXTENDED_MONITORING_DURATION = 120000L;
    private static final int FINAL_CHECK_COUNT = 2;
    private ObjectReferenceService _objRefService;
    private Map<String, Object> _objects = new HashMap<String, Object>();
    private Map<String, ExtendedMonitoringData> _objectsForExtendedMonitoring = new HashMap<String, ExtendedMonitoringData>();
    private Map<String, FinalCheckData> _pendingFinalChecks = new HashMap<String, FinalCheckData>();

    public MonitorRegistry(ObjectReferenceService objectReferenceService) {
        this._objRefService = objectReferenceService;
    }

    public synchronized void add(Object object) {
        String string = this.getUid(object);
        this._objects.put(string, object);
        this.removePendingFinalCheck(object);
    }

    public synchronized void remove(Object object, boolean bl) {
        FinalCheckData finalCheckData = new FinalCheckData();
        finalCheckData.reference = object;
        finalCheckData.numChecksLeft = 2;
        String string = this.getUid(object);
        this._pendingFinalChecks.put(string, finalCheckData);
        if (bl) {
            ExtendedMonitoringData extendedMonitoringData = new ExtendedMonitoringData();
            extendedMonitoringData.reference = object;
            extendedMonitoringData.startTime = new Date();
            this._objectsForExtendedMonitoring.put(string, extendedMonitoringData);
        }
    }

    public synchronized void onCheckComplete(List<Object> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list);
        for (Object e : arrayList) {
            long l;
            ExtendedMonitoringData extendedMonitoringData;
            String string = this.getUid(e);
            FinalCheckData finalCheckData = this._pendingFinalChecks.get(string);
            if (finalCheckData != null && --finalCheckData.numChecksLeft <= 0) {
                this.removePendingFinalCheck(string);
                this._objects.remove(string);
            }
            if ((extendedMonitoringData = this._objectsForExtendedMonitoring.get(string)) == null || (l = System.currentTimeMillis() - extendedMonitoringData.startTime.getTime()) <= 120000L) continue;
            this._objectsForExtendedMonitoring.remove(string);
        }
    }

    public synchronized List<Object> getMonitoredObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this._objects.values());
        for (ExtendedMonitoringData extendedMonitoringData : this._objectsForExtendedMonitoring.values()) {
            if (this._objects.containsKey(this.getUid(extendedMonitoringData.reference))) continue;
            arrayList.add(extendedMonitoringData.reference);
        }
        return arrayList;
    }

    public synchronized boolean hasObjectsForMonitoring() {
        return this._objects.size() > 0 || this._objectsForExtendedMonitoring.size() > 0;
    }

    private void removePendingFinalCheck(Object object) {
        String string = this.getUid(object);
        this._pendingFinalChecks.remove(string);
    }

    private String getUid(Object object) {
        return this._objRefService.getUid(object, true);
    }

    private class ExtendedMonitoringData {
        public Object reference;
        public Date startTime;

        private ExtendedMonitoringData() {
        }
    }

    private class FinalCheckData {
        public Object reference;
        public volatile int numChecksLeft;

        private FinalCheckData() {
        }
    }
}

