/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.updates.monitor.impl;

import com.vmware.vise.core.model.Message;
import com.vmware.vise.core.model.ModelChangeMessage;
import com.vmware.vise.core.model.ObjectChangeInfo;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.updates.monitor.ObjectChangeMonitor;
import com.vmware.vise.data.updates.monitor.ObjectChangeService;
import com.vmware.vise.data.updates.monitor.impl.MonitorRegistry;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.messaging.MessagingService;
import com.vmware.vise.util.session.SessionUtil;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectChangeMonitorImpl
implements ObjectChangeMonitor,
Runnable {
    private final int POLL_INTERVAL = 1000;
    private static final Log _logger = LogFactory.getLog(ObjectChangeMonitorImpl.class);
    private ObjectChangeService _changeService;
    private MessagingService _messagingService;
    private MonitorRegistry _monitorRegistry;
    private volatile boolean _nextPollScheduled = false;
    private final ThreadFactory _schedulerThreadFactory = new WorkerThreadFactory("ObjectChangeMonitorScheduler");
    private ScheduledThreadPoolExecutor _scheduler = new ScheduledThreadPoolExecutor(1, this._schedulerThreadFactory);
    private HttpSession _session = null;

    public ObjectChangeMonitorImpl(ObjectChangeService objectChangeService, MessagingService messagingService, ObjectReferenceService objectReferenceService) {
        this._changeService = objectChangeService;
        this._messagingService = messagingService;
        this._monitorRegistry = new MonitorRegistry(objectReferenceService);
        this._session = SessionUtil.getHttpSession();
    }

    @Override
    public void add(Object object) {
        this._monitorRegistry.add(object);
        this.scheduleNextPoll();
    }

    @Override
    public void remove(Object object, boolean bl) {
        this._monitorRegistry.remove(object, bl);
    }

    public void shutdown() {
        this._scheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<Object> list = this._monitorRegistry.getMonitoredObjects();
        if (list.size() > 0) {
            try {
                SessionUtil.setHttpSession((HttpSession)this._session);
                List<ObjectChangeInfo> list2 = this._changeService.getChanges(list);
                this.sendModelChangedEvent(list2);
            }
            catch (Exception exception) {
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
                _logger.error((Object)"Failed to detect changes.", (Throwable)exception);
            }
            finally {
                SessionUtil.setHttpSession(null);
                this.resetNextPollScheduled();
                this._monitorRegistry.onCheckComplete(list);
            }
        }
        this.scheduleNextPoll();
    }

    private synchronized void resetNextPollScheduled() {
        this._nextPollScheduled = false;
    }

    private synchronized void scheduleNextPoll() {
        if (!this._nextPollScheduled && this._monitorRegistry.hasObjectsForMonitoring()) {
            this._scheduler.schedule(this, 1000L, TimeUnit.MILLISECONDS);
            this._nextPollScheduled = true;
        }
    }

    private void sendModelChangedEvent(List<ObjectChangeInfo> list) {
        for (ObjectChangeInfo objectChangeInfo : list) {
            ModelChangeMessage modelChangeMessage = new ModelChangeMessage();
            modelChangeMessage.setObjectChangeInfo(objectChangeInfo);
            this._messagingService.sendMessage((Message)modelChangeMessage);
        }
    }
}

