/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.fs;

import com.vmware.vim.zeppelin.cr.auth.CRAccessControl;
import com.vmware.vim.zeppelin.cr.auth.CRUser;
import com.vmware.vim.zeppelin.cr.exception.CRAccessDeniedException;
import com.vmware.vim.zeppelin.cr.exception.CRException;
import com.vmware.vim.zeppelin.cr.exception.CRFileExistsException;
import com.vmware.vim.zeppelin.cr.exception.CRFileNotExistsException;
import com.vmware.vim.zeppelin.cr.exception.CRFolderNotEmptyException;
import com.vmware.vim.zeppelin.cr.fs.CRFileData;
import com.vmware.vim.zeppelin.cr.node.CRFileNode;
import com.vmware.vim.zeppelin.cr.node.CRFolderNode;
import com.vmware.vim.zeppelin.cr.node.CRNode;
import com.vmware.vim.zeppelin.cr.search.CRSearchQuery;
import com.vmware.vim.zeppelin.cr.versionctrl.CRChangeset;
import com.vmware.vim.zeppelin.cr.versionctrl.CRFileRevision;
import java.util.List;
import java.util.Map;

public interface CRFileSystem {
    public void close();

    public void setUser(CRUser var1);

    public boolean exists(String var1);

    public boolean hasChildren(String var1);

    public boolean isFolder(String var1);

    public boolean isFile(String var1);

    public CRNode getFolderNode(String var1) throws CRAccessDeniedException;

    public List<CRFolderNode> listFolders(String var1, boolean var2);

    public List<CRFileNode> listFiles(String var1, boolean var2);

    public List<CRFileNode> listFiles(String var1, boolean var2, CRSearchQuery var3);

    public CRFileRevision getLatestFileRevision(String var1) throws CRAccessDeniedException;

    public CRFileNode getFileNode(String var1) throws CRAccessDeniedException;

    public CRFileRevision getFileRevision(String var1, int var2) throws CRAccessDeniedException;

    public void commitChangeset(CRChangeset var1) throws CRException;

    public void addFolder(String var1, List<CRAccessControl> var2) throws CRAccessDeniedException;

    public CRFileRevision addFile(String var1, List<CRAccessControl> var2, CRFileData var3) throws CRAccessDeniedException, CRFileExistsException;

    public CRFileRevision addFile(String var1, List<CRAccessControl> var2, CRFileData var3, Map<String, String> var4) throws CRAccessDeniedException, CRFileExistsException;

    public void deleteFile(String var1) throws CRAccessDeniedException;

    public void deleteFolder(String var1) throws CRAccessDeniedException, CRFolderNotEmptyException;

    public CRFileRevision updateFile(String var1, CRFileData var2, boolean var3) throws CRAccessDeniedException, CRFileNotExistsException;

    public CRFileRevision updateFile(String var1, CRFileData var2, Map<String, String> var3, boolean var4) throws CRAccessDeniedException, CRFileNotExistsException;

    public void addAcls(String var1, List<CRAccessControl> var2) throws CRAccessDeniedException, CRFileNotExistsException;

    public void removeAcl(String var1, CRAccessControl var2) throws CRAccessDeniedException, CRFileNotExistsException;

    public void rollbackToRevision(String var1, int var2) throws CRAccessDeniedException;
}

